/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.service;

import eu.miaplatform.service.InitServiceOptions;
import eu.miaplatform.service.ServiceOptions;
import java.io.IOException;
import java.util.Arrays;
import okhttp3.ConnectionSpec;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.Nullable;

public class Service {
    private static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String serviceName;
    private Headers headers;
    private InitServiceOptions options;
    private OkHttpClient client = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT)).build();

    public Service(String serviceName, InitServiceOptions options) {
        this.serviceName = serviceName;
        this.headers = Headers.of(options.getHeaders());
        this.options = options;
    }

    private HttpUrl buildUrl(String path, String queryString, InitServiceOptions options) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().host(this.serviceName).addPathSegment(path);
        urlBuilder.port(options == null ? this.options.getPort() : options.getPort());
        urlBuilder.scheme(options == null ? this.options.getProtocol().toString() : options.getProtocol().toString());
        if (queryString != null) {
            urlBuilder.query(queryString);
        }
        return urlBuilder.build();
    }

    public Response get(String path, @Nullable String queryString, @Nullable ServiceOptions options) throws IOException {
        HttpUrl url = this.buildUrl(path, queryString, options);
        Request request = new Request.Builder().headers(this.headers).url(url).build();
        return this.client.newCall(request).execute();
    }

    public Response post(String path, String body, @Nullable String queryString, @Nullable ServiceOptions options) throws IOException {
        HttpUrl url = this.buildUrl(path, queryString, options);
        RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)body);
        Request request = new Request.Builder().headers(this.headers).url(url).post(reqBody).build();
        return this.client.newCall(request).execute();
    }

    public Response put(String path, String body, @Nullable String queryString, @Nullable ServiceOptions options) throws IOException {
        HttpUrl url = this.buildUrl(path, queryString, options);
        RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)body);
        Request request = new Request.Builder().headers(this.headers).url(url).put(reqBody).build();
        return this.client.newCall(request).execute();
    }

    public Response patch(String path, String body, @Nullable String queryString, @Nullable ServiceOptions options) throws IOException {
        HttpUrl url = this.buildUrl(path, queryString, options);
        RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)body);
        Request request = new Request.Builder().headers(this.headers).url(url).patch(reqBody).build();
        return this.client.newCall(request).execute();
    }

    public Response delete(String path, String body, @Nullable String queryString, @Nullable ServiceOptions options) throws IOException {
        HttpUrl url = this.buildUrl(path, queryString, options);
        RequestBody reqBody = RequestBody.create((MediaType)JSON, (String)body);
        Request request = new Request.Builder().headers(this.headers).url(url).delete(reqBody).build();
        return this.client.newCall(request).execute();
    }
}

