/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.crud.library;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.miaplatform.crud.library.CRUDError;
import eu.miaplatform.crud.library.CRUDObject;
import eu.miaplatform.crud.library.GsonFactory;
import eu.miaplatform.crud.library.Network;
import eu.miaplatform.crud.library.PATCH;
import eu.miaplatform.crud.library.enums.Parameters;
import eu.miaplatform.crud.library.enums.PatchCodingKey;
import eu.miaplatform.crud.library.enums.State;
import eu.miaplatform.crud.library.listeners.SingleObjectCallback;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0002J\u0016\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0003J\u0016\u0010!\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020$J\u0014\u0010\u0012\u001a\u00020\u00152\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020$0%J\u0010\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0016\u001a\u00020\u0003J%\u0010'\u001a\u00020\u0015\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010*\u001a\u0002H(2\u0006\u0010 \u001a\u00020\u0003\u00a2\u0006\u0002\u0010+J%\u0010,\u001a\u00020\u0015\"\b\b\u0000\u0010(*\u00020)2\u0006\u0010*\u001a\u0002H(2\u0006\u0010 \u001a\u00020\u0003\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Leu/miaplatform/crud/library/PATCH;", "", "collection", "", "network", "Leu/miaplatform/crud/library/Network;", "crudVersion", "", "(Ljava/lang/String;Leu/miaplatform/crud/library/Network;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "currentDate", "Ljava/util/HashMap;", "", "inc", "", "mul", "set", "setOnInsert", "state", "unset", "async", "", "id", "callback", "Leu/miaplatform/crud/library/listeners/SingleObjectCallback;", "buildBody", "Lokhttp3/RequestBody;", "createRawBodyFromJson", "json", "getQueryParameters", "increment", "value", "property", "multiply", "removeObject", "setCurrentDate", "Leu/miaplatform/crud/library/enums/State;", "Ljava/util/ArrayList;", "sync", "update", "T", "Ljava/io/Serializable;", "newObject", "(Ljava/io/Serializable;Ljava/lang/String;)V", "updateOnInsert", "mia-service-java-library"})
public final class PATCH {
    private String state;
    private HashMap<String, Object> set;
    private HashMap<String, Object> setOnInsert;
    private HashMap<String, Boolean> unset;
    private HashMap<String, Double> inc;
    private HashMap<String, Double> mul;
    private HashMap<String, Boolean> currentDate;
    private final String collection;
    private final Network network;
    private final Integer crudVersion;

    public final void async(@NotNull String id, @NotNull SingleObjectCallback<String> callback) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        String queryParameters = this.getQueryParameters();
        String partialPath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' + id : this.collection + '/' + id;
        CharSequence charSequence = queryParameters;
        String relativePath = charSequence.length() == 0 ? partialPath : partialPath + '?' + queryParameters;
        RequestBody body = this.buildBody();
        this.network.getQueryRestInterface().patch(relativePath, body).enqueue((Callback)new Callback<JsonObject>(callback){
            final /* synthetic */ SingleObjectCallback $callback;

            public void onResponse(@Nullable Call<JsonObject> call, @NotNull Response<JsonObject> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                CRUDError error = null;
                String result = null;
                if (response.isSuccessful() && response.body() != null) {
                    try {
                        Object object = response.body();
                        if (object == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()!!");
                        JsonObject obj = ((JsonObject)object).getAsJsonObject();
                        JsonElement jsonElement = obj.get("_id");
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj.get(\"_id\")");
                        result = jsonElement.getAsString();
                    }
                    catch (Exception e) {
                        error = new CRUDError(e.getMessage());
                    }
                } else {
                    error = new CRUDError("Error code " + response.code());
                }
                this.$callback.onCompleted(result, error);
            }

            public void onFailure(@Nullable Call<JsonObject> call, @Nullable Throwable t) {
                Throwable throwable = t;
                this.$callback.onCompleted(null, new CRUDError(throwable != null ? throwable.getMessage() : null));
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        });
    }

    @Nullable
    public final String sync(@NotNull String id) {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        String queryParameters = this.getQueryParameters();
        String partialPath = this.crudVersion != null ? "" + 'v' + this.crudVersion + '/' + this.collection + '/' + id : this.collection + '/' + id;
        CharSequence charSequence = queryParameters;
        String relativePath = charSequence.length() == 0 ? partialPath : partialPath + '?' + queryParameters;
        RequestBody body = this.buildBody();
        Response response2 = response = this.network.getQueryRestInterface().patch(relativePath, body).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (response2.isSuccessful()) {
            try {
                Object object = response.body();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.gson.JsonObject");
                }
                JsonObject obj = (JsonObject)object;
                JsonElement jsonElement = obj.get("_id");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"obj.get(\"_id\")");
                return jsonElement.getAsString();
            }
            catch (Exception e) {
                throw (Throwable)e;
            }
        }
        throw (Throwable)new CRUDError("Error code " + response.code());
    }

    public final <T extends Serializable> void update(@NotNull T newObject, @NotNull String property) {
        HashMap<Object, Object> hashMap;
        Intrinsics.checkParameterIsNotNull(newObject, (String)"newObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (ArraysKt.contains((Object[])CRUDObject.INSTANCE.getCollectionDefaultProperties(), (Object)property)) {
            return;
        }
        if (this.set == null) {
            hashMap = new HashMap();
        } else {
            hashMap = this.set;
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
        }
        HashMap<Object, Object> temp = hashMap;
        if (newObject instanceof Date) {
            String formattedDate = CRUDObject.INSTANCE.toISO8601((Date)newObject);
            Map map = temp;
            String string = formattedDate;
            map.put(property, string);
        } else {
            Map map = temp;
            T t = newObject;
            map.put(property, t);
        }
        this.set = temp;
    }

    public final <T extends Serializable> void updateOnInsert(@NotNull T newObject, @NotNull String property) {
        HashMap<Object, Object> hashMap;
        Intrinsics.checkParameterIsNotNull(newObject, (String)"newObject");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (ArraysKt.contains((Object[])CRUDObject.INSTANCE.getCollectionDefaultProperties(), (Object)property)) {
            return;
        }
        if (this.setOnInsert == null) {
            hashMap = new HashMap();
        } else {
            hashMap = this.setOnInsert;
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
        }
        HashMap<Object, Object> temp = hashMap;
        if (newObject instanceof Date) {
            String formattedDate = CRUDObject.INSTANCE.toISO8601((Date)newObject);
            Map map = temp;
            String string = formattedDate;
            map.put(property, string);
        } else {
            Map map = temp;
            T t = newObject;
            map.put(property, t);
        }
        this.setOnInsert = temp;
    }

    public final void removeObject(@NotNull String property) {
        HashMap<Object, Object> hashMap;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (ArraysKt.contains((Object[])CRUDObject.INSTANCE.getCollectionDefaultProperties(), (Object)property)) {
            return;
        }
        if (this.unset == null) {
            hashMap = new HashMap();
        } else {
            hashMap = this.unset;
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
        }
        HashMap<Object, Object> temp = hashMap;
        Map map = temp;
        Boolean bl = true;
        map.put(property, bl);
        this.unset = temp;
    }

    public final void increment(double value, @NotNull String property) {
        HashMap<Object, Object> hashMap;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (ArraysKt.contains((Object[])CRUDObject.INSTANCE.getCollectionDefaultProperties(), (Object)property)) {
            return;
        }
        if (this.inc == null) {
            hashMap = new HashMap();
        } else {
            hashMap = this.inc;
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
        }
        HashMap<Object, Object> temp = hashMap;
        Map map = temp;
        Double d = value;
        map.put(property, d);
        this.inc = temp;
    }

    public final void multiply(double value, @NotNull String property) {
        HashMap<Object, Object> hashMap;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (ArraysKt.contains((Object[])CRUDObject.INSTANCE.getCollectionDefaultProperties(), (Object)property)) {
            return;
        }
        if (this.mul == null) {
            hashMap = new HashMap();
        } else {
            hashMap = this.mul;
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
        }
        HashMap<Object, Object> temp = hashMap;
        Map map = temp;
        Double d = value;
        map.put(property, d);
        this.mul = temp;
    }

    public final void setCurrentDate(@NotNull String property) {
        HashMap<Object, Object> hashMap;
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        if (ArraysKt.contains((Object[])CRUDObject.INSTANCE.getCollectionDefaultProperties(), (Object)property)) {
            return;
        }
        if (this.currentDate == null) {
            hashMap = new HashMap();
        } else {
            hashMap = this.currentDate;
            if (hashMap == null) {
                Intrinsics.throwNpe();
            }
        }
        HashMap<Object, Object> temp = hashMap;
        Map map = temp;
        Boolean bl = true;
        map.put(property, bl);
        this.currentDate = temp;
    }

    public final void state(@NotNull State state2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state2), (String)"state");
        this.state = state2.getValue();
    }

    public final void state(@NotNull ArrayList<State> state2) {
        Intrinsics.checkParameterIsNotNull(state2, (String)"state");
        this.state = CollectionsKt.joinToString$default((Iterable)state2, (CharSequence)",", null, null, (int)0, null, (Function1)state.1.INSTANCE, (int)30, null);
    }

    private final RequestBody buildBody() {
        String jsonString;
        JsonObject jsonObject = new JsonObject();
        if (this.set != null) {
            jsonObject.add(PatchCodingKey.Set.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(this.set));
        }
        if (this.setOnInsert != null) {
            jsonObject.add(PatchCodingKey.SetOnInsert.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(this.setOnInsert));
        }
        if (this.unset != null) {
            jsonObject.add(PatchCodingKey.Unset.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(this.unset));
        }
        if (this.inc != null) {
            jsonObject.add(PatchCodingKey.Inc.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(this.inc));
        }
        if (this.mul != null) {
            jsonObject.add(PatchCodingKey.Mul.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(this.mul));
        }
        if (this.currentDate != null) {
            jsonObject.add(PatchCodingKey.CurrentDate.getValue(), GsonFactory.Companion.newGsonInstance().toJsonTree(this.currentDate));
        }
        String string = jsonString = GsonFactory.Companion.newGsonInstance().toJson((JsonElement)jsonObject);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"jsonString");
        RequestBody requestBody = this.createRawBodyFromJson(string);
        if (requestBody == null) {
            Intrinsics.throwNpe();
        }
        return requestBody;
    }

    private final RequestBody createRawBodyFromJson(String json) {
        try {
            Object object;
            String string = json;
            Object object2 = "UTF-8";
            MediaType mediaType = MediaType.parse((String)"application/json");
            Charset charset = Charset.forName((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object2 = object = charset;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            object = byArray;
            return RequestBody.create((MediaType)mediaType, (byte[])object);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getQueryParameters() {
        void $receiver$iv$iv;
        Object object;
        HashMap queryParameters = new HashMap();
        if (this.state != null) {
            Map map = queryParameters;
            object = Parameters.STATE.getValue();
            String string = this.state;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = string;
            map.put(object, string2);
        }
        Map $receiver$iv = queryParameters;
        object = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var5_5 = $receiver$iv$iv;
        Iterator iterator = var5_5.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            String string = (String)it.getKey() + '=' + it.getValue();
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    public PATCH(@NotNull String collection, @NotNull Network network, @Nullable Integer crudVersion) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
        this.collection = collection;
        this.network = network;
        this.crudVersion = crudVersion;
    }

    public /* synthetic */ PATCH(String string, Network network, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(string, network, n);
    }
}

