/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.customplugin.springboot;

import eu.miaplatform.customplugin.springboot.FilterServletInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CPRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] body;
    private Map<String, String[]> modifiableQueryParameters = new TreeMap<String, String[]>();
    private Map<String, String> headerMap = new HashMap<String, String>();

    public CPRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        ServletInputStream is = super.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int reads = is.read();
        while (reads != -1) {
            baos.write(reads);
            reads = is.read();
        }
        this.body = baos.toByteArray();
        this.modifiableQueryParameters.putAll(super.getParameterMap());
    }

    public ServletInputStream getInputStream() {
        return new FilterServletInputStream(new ByteArrayInputStream(this.body));
    }

    public BufferedReader getReader() throws IOException {
        String enc = this.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), enc));
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        names.addAll(this.headerMap.keySet());
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList values = Collections.list(super.getHeaders(name));
        if (this.headerMap.containsKey(name)) {
            values.add(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }

    public Map<String, String[]> getQueryParameters() {
        return this.modifiableQueryParameters;
    }

    public void setQueryParameters(Map<String, String[]> queryParameters) {
        this.modifiableQueryParameters = queryParameters;
    }

    public String getParameter(String name) {
        String[] strings = this.getParameterMap().get(name);
        if (strings != null) {
            return strings[0];
        }
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.modifiableQueryParameters);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getPath() {
        return this.getServletPath();
    }

    public String getBody() throws IOException {
        return this.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public void setBody(String body) {
        this.body = body.getBytes();
    }
}

