/*
 * Decompiled with CFR 0.152.
 */
package eu.maxschuster.dataurl;

import eu.maxschuster.dataurl.DataUrl;
import eu.maxschuster.dataurl.DataUrlEncoding;
import eu.maxschuster.dataurl.IDataUrlSerializer;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataUrlSerializer
implements IDataUrlSerializer {
    private static final long serialVersionUID = 1L;
    private final Pattern PATTERN_META_SPLIT = Pattern.compile(";");
    private static final Pattern PATTERN_MIMETYPE = Pattern.compile("^[a-z\\-0-9]+\\/[a-z\\-0-9]+$");
    private final Base64Encoder base64Encoder = new Base64Encoder();
    private final URLEncodedEncoder urlEncodedEncoder = new URLEncodedEncoder();

    @Override
    public String serialize(DataUrl dataURL) throws MalformedURLException {
        String encodingName;
        DataUrlEncoding encoding = dataURL.getEncoding();
        IEncoder encoder = this.getAppliedEncoder(encoding);
        Map<String, String> headers = dataURL.getHeaders();
        int headerSize = headers != null ? headers.size() : 0;
        StringBuilder sb = new StringBuilder("data:");
        String mimeType = dataURL.getMimeType();
        if (mimeType != null) {
            sb.append(mimeType);
            if (headerSize > 0 || encoding != DataUrlEncoding.URL) {
                sb.append(';');
            }
        }
        if (headers != null && headerSize > 0) {
            int i = 0;
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String value;
                try {
                    value = URLEncoding.encode(entry.getValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError();
                }
                sb.append(entry.getKey()).append('=').append(value);
                if (++i >= headerSize && encoding == DataUrlEncoding.URL) continue;
                sb.append(';');
            }
        }
        if (!(encodingName = encoding.getEncodingName()).isEmpty()) {
            sb.append(encodingName);
        }
        sb.append(',');
        String appliedCharset = this.getAppliedCharset(headers);
        try {
            sb.append(encoder.encode(appliedCharset, dataURL.getData()));
        }
        catch (Exception e) {
            throw new MalformedURLException("Error encoding the data");
        }
        return sb.toString();
    }

    @Override
    public DataUrl unserialize(String urlString) throws MalformedURLException {
        DataUrlEncoding encoding;
        if (urlString == null) {
            throw new NullPointerException();
        }
        byte[] data = null;
        String mimeType = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!urlString.startsWith("data:")) {
            throw new MalformedURLException("Wrong protocol");
        }
        int colon = urlString.indexOf(58);
        int comma = urlString.indexOf(44);
        String metaString = urlString.substring(colon + 1, comma);
        String dataString = urlString.substring(comma + 1);
        String encodingName = "";
        String[] metaArray = this.PATTERN_META_SPLIT.split(metaString);
        for (int i = 0; i < metaArray.length; ++i) {
            Matcher m;
            String meta = metaArray[i];
            if (i == 0 && (m = PATTERN_MIMETYPE.matcher(meta)).matches()) {
                mimeType = meta;
                continue;
            }
            if (i + 1 == metaArray.length && meta.indexOf(61) == -1) {
                encodingName = meta;
                continue;
            }
            int equals = meta.indexOf(61);
            if (equals < 1) {
                throw new MalformedURLException();
            }
            String name = meta.substring(0, equals);
            String value = meta.substring(equals + 1);
            try {
                headers.put(name, URLEncoding.decode(value, "UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            encoding = DataUrlEncoding.valueOfEncodingName(encodingName);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Unknown encoding \"" + encodingName + "\"");
        }
        IEncoder encoder = this.getAppliedEncoder(encoding);
        String appliedCharset = this.getAppliedCharset(headers);
        try {
            data = encoder.decode(appliedCharset, dataString);
        }
        catch (Exception e) {
            throw new MalformedURLException("");
        }
        DataUrl dataUrl = new DataUrl(data, encoding, mimeType, headers);
        return dataUrl;
    }

    protected String getAppliedCharset(Map<String, String> headers) {
        String encoding;
        if (headers != null && (encoding = headers.get("charset")) != null) {
            return encoding;
        }
        return "US-ASCII";
    }

    protected IEncoder getAppliedEncoder(DataUrlEncoding encoding) {
        switch (encoding) {
            case BASE64: {
                return this.base64Encoder;
            }
            case URL: {
                return this.urlEncodedEncoder;
            }
        }
        throw new IllegalArgumentException();
    }

    private static class URLEncoding {
        private URLEncoding() {
        }

        public static String encode(String s, String enc) throws UnsupportedEncodingException {
            return URLEncoder.encode(s, enc).replace("+", "%20");
        }

        public static String decode(String s, String enc) throws UnsupportedEncodingException {
            return URLDecoder.decode(s.replace("%20", "+"), enc);
        }
    }

    protected class URLEncodedEncoder
    implements IEncoder {
        private static final long serialVersionUID = 1L;

        protected URLEncodedEncoder() {
        }

        @Override
        public byte[] decode(String charset, String string) throws Exception {
            return URLEncoding.decode(string, charset).getBytes(charset);
        }

        @Override
        public String encode(String charset, byte[] data) throws Exception {
            return URLEncoding.encode(new String(data, charset), charset);
        }
    }

    protected class Base64Encoder
    implements IEncoder {
        private static final long serialVersionUID = 1L;

        protected Base64Encoder() {
        }

        @Override
        public byte[] decode(String charset, String string) {
            return Base64.getDecoder().decode(string);
        }

        @Override
        public String encode(String charset, byte[] data) {
            return new String(Base64.getEncoder().encode(data));
        }
    }

    protected static interface IEncoder
    extends Serializable {
        public byte[] decode(String var1, String var2) throws Exception;

        public String encode(String var1, byte[] var2) throws Exception;
    }
}

