/*
 * Decompiled with CFR 0.152.
 */
package eu.maxschuster.dataurl;

import eu.maxschuster.dataurl.DataUrl;
import eu.maxschuster.dataurl.DataUrlEncoding;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DataUrlBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] data;
    private String mimeType;
    private DataUrlEncoding encoding;
    private Map<String, String> headers;

    public DataUrl build() throws NullPointerException {
        if (this.data == null) {
            throw new NullPointerException("data is null!");
        }
        if (this.encoding == null) {
            throw new NullPointerException("encoding is null!");
        }
        return new DataUrl(this.data, this.encoding, this.mimeType, this.headers);
    }

    public byte[] getData() {
        return this.data;
    }

    public DataUrlBuilder setData(byte[] data) {
        this.data = data;
        return this;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public DataUrlBuilder setMimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public DataUrlEncoding getEncoding() {
        return this.encoding;
    }

    public DataUrlBuilder setEncoding(DataUrlEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public DataUrlBuilder setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public DataUrlBuilder setHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(name, value);
        return this;
    }

    public DataUrlBuilder setCharset(String charset) {
        this.setHeader("charset", charset);
        return this;
    }

    public DataUrlBuilder setDataUrl(DataUrl template) {
        this.setData(template.getData());
        this.setEncoding(template.getEncoding());
        this.setHeaders(template.getHeaders());
        this.setMimeType(template.getMimeType());
        return this;
    }
}

