/*
 * Decompiled with CFR 0.152.
 */
package eu.maxschuster.dataurl;

import eu.maxschuster.dataurl.DataUrlEncoding;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DataUrl
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] data;
    private final DataUrlEncoding encoding;
    private final String mimeType;
    private final Map<String, String> headers;

    public DataUrl(byte[] data, DataUrlEncoding encoding, String mimeType, Map<String, String> headers) throws NullPointerException {
        if (data == null) {
            throw new NullPointerException("data is null!");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is null!");
        }
        this.data = data;
        this.encoding = encoding;
        this.mimeType = mimeType;
        this.headers = headers != null ? Collections.unmodifiableMap(new LinkedHashMap<String, String>(headers)) : Collections.emptyMap();
    }

    public DataUrl(byte[] data, DataUrlEncoding encoding, String mimeType) throws NullPointerException {
        this(data, encoding, mimeType, null);
    }

    public DataUrl(byte[] data, DataUrlEncoding encoding) throws NullPointerException {
        this(data, encoding, null);
    }

    public DataUrl(byte[] data) throws NullPointerException {
        this(data, DataUrlEncoding.URL);
    }

    public byte[] getData() {
        return this.data;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public DataUrlEncoding getEncoding() {
        return this.encoding;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Arrays.hashCode(this.data);
        hash = 97 * hash + (this.mimeType != null ? this.mimeType.hashCode() : 0);
        hash = 97 * hash + (this.encoding != null ? this.encoding.hashCode() : 0);
        hash = 97 * hash + (this.headers != null ? this.headers.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataUrl other = (DataUrl)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.encoding != other.encoding) {
            return false;
        }
        return this.headers == other.headers || this.headers != null && this.headers.equals(other.headers);
    }

    public String toString() {
        return "DataUrl{ mimeType = \"" + this.mimeType + "\", encoding = \"" + (Object)((Object)this.encoding) + "\", headers = \"" + this.headers + "\", data.length = \"" + this.data.length + " bytes\" }";
    }
}

