/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.component;

import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;

public class ButtonRectangle
extends Rectangle {
    private SimpleObjectProperty<Command> commandProperty = new SimpleObjectProperty();
    private PositionGradient positionGradient;
    private double percentValue_X;
    private double percenValue_Y;
    private double percentValue_Width;
    private double percentValue_Height;
    private double arcWidthAndHeight;
    private Color baseColor = Color.web((String)"#5abaa0");

    public ButtonRectangle(PositionGradient positionGradient, double percentValue_X, double percenValue_Y, double percentValue_Width, double percentValue_Height, double arcWidthAndHeight) {
        this.positionGradient = positionGradient;
        this.percentValue_X = percentValue_X;
        this.percenValue_Y = percenValue_Y;
        this.percentValue_Width = percentValue_Width;
        this.percentValue_Height = percentValue_Height;
        this.arcWidthAndHeight = arcWidthAndHeight;
        this.setOnMousePressed(e -> this.setNodeMouseEvent(Command.BUTTON_PRESSED, (MouseEvent)e));
        this.setOnMouseReleased(e -> this.setNodeMouseEvent(Command.BUTTON_RELEASED, (MouseEvent)e));
    }

    private void setNodeMouseEvent(Command commandValue, MouseEvent e) {
        if (commandValue == Command.BUTTON_PRESSED) {
            LinearGradient gradient = null;
            gradient = this.positionGradient == PositionGradient.FROM_DOWN_TO_UP ? new LinearGradient(0.0, 0.3, 0.0, 1.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.baseColor), new Stop(1.0, this.baseColor.darker())}) : new LinearGradient(0.0, 0.0, 0.0, 0.7, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(1.0, this.baseColor), new Stop(0.0, this.baseColor.darker())});
            this.setFill((Paint)gradient);
        } else if (commandValue == Command.BUTTON_RELEASED) {
            this.setFill((Paint)this.baseColor);
        }
        this.commandProperty.set((Object)commandValue);
        e.consume();
    }

    public SimpleObjectProperty<Command> getCommandProperty() {
        return this.commandProperty;
    }

    public void refreshSize(double width_component, double height_component) {
        this.setX(width_component * this.percentValue_X);
        this.setY(height_component * this.percenValue_Y);
        this.setWidth(width_component * this.percentValue_Width);
        this.setHeight(height_component * this.percentValue_Height);
        this.setArcWidth(width_component * this.arcWidthAndHeight);
        this.setArcHeight(width_component * this.arcWidthAndHeight);
    }

    public void setBaseColor(Color newValue) {
        this.baseColor = newValue;
        this.setFill((Paint)this.baseColor);
    }

    public static enum Command {
        BUTTON_PRESSED,
        BUTTON_RELEASED,
        RESET_COMMAND;

    }

    public static enum PositionGradient {
        FROM_DOWN_TO_UP,
        FROM_UP_TO_DOWN;

    }
}

