/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.component.sensor;

import eu.matfx.component.ButtonRectangle;
import eu.matfx.component.sensor.AValueComponent;
import eu.matfx.tools.Command;
import eu.matfx.tools.UIToolBox;
import eu.matfx.tools.Value_Color_Component;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class MoreValueComponent
extends AValueComponent {
    private double width_component = 90.0;
    private double height_component = 100.0;
    private Canvas topCanvas;
    private Canvas bottomCanvas;
    private Canvas textCanvas;
    protected ButtonRectangle button_up;
    protected ButtonRectangle button_down;
    private SimpleObjectProperty<Value_Color_Component> valueProperty = new SimpleObjectProperty();
    private SimpleObjectProperty<Value_Color_Component> valueTopProperty = new SimpleObjectProperty();
    private SimpleObjectProperty<Value_Color_Component> valueBottomProperty = new SimpleObjectProperty();

    public MoreValueComponent() {
        this.initGraphics();
        this.registerListener();
    }

    @Override
    protected void initGraphics() {
        this.topCanvas = new Canvas();
        this.textCanvas = new Canvas();
        this.bottomCanvas = new Canvas();
        this.button_down = new ButtonRectangle(ButtonRectangle.PositionGradient.FROM_UP_TO_DOWN, 0.23555555562222225, 0.92000000001, 0.5288888887222222, 0.07999999995, 0.022222222222222223);
        this.button_down.setFill((Paint)this.baseColor.get());
        this.button_down.getCommandProperty().addListener((ChangeListener)new ChangeListener<ButtonRectangle.Command>(){

            public void changed(ObservableValue<? extends ButtonRectangle.Command> observable, ButtonRectangle.Command oldValue, ButtonRectangle.Command newValue) {
                if (newValue == ButtonRectangle.Command.BUTTON_RELEASED) {
                    MoreValueComponent.this.getCommandProperty().set((Object)Command.RESET_COMMAND);
                    MoreValueComponent.this.getCommandProperty().set((Object)Command.NEXT_SENSOR_VALUE);
                }
            }
        });
        this.button_up = new ButtonRectangle(ButtonRectangle.PositionGradient.FROM_DOWN_TO_UP, 0.23555555563333336, 0.0, 0.5288888887222222, 0.07999999995, 0.022222222222222223);
        this.button_up.setFill((Paint)this.baseColor.get());
        this.button_up.getCommandProperty().addListener((ChangeListener)new ChangeListener<ButtonRectangle.Command>(){

            public void changed(ObservableValue<? extends ButtonRectangle.Command> observable, ButtonRectangle.Command oldValue, ButtonRectangle.Command newValue) {
                if (newValue == ButtonRectangle.Command.BUTTON_RELEASED) {
                    MoreValueComponent.this.getCommandProperty().set((Object)Command.RESET_COMMAND);
                    MoreValueComponent.this.getCommandProperty().set((Object)Command.PREVIOUS_SENSOR_VALUE);
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.base_background_component, this.topCanvas, this.textCanvas, this.bottomCanvas, this.button_down, this.button_up});
    }

    @Override
    protected void registerListener() {
        this.widthProperty().addListener(observable -> this.resize());
        this.heightProperty().addListener(observable -> this.resize());
        this.valueProperty.set((Object)new Value_Color_Component(""));
        this.valueProperty.addListener((ChangeListener)new ChangeListener<Value_Color_Component>(){

            public void changed(ObservableValue<? extends Value_Color_Component> observable, Value_Color_Component oldValue, Value_Color_Component newValue) {
                MoreValueComponent.this.resize();
            }
        });
        this.valueTopProperty.set((Object)new Value_Color_Component(""));
        this.valueTopProperty.addListener((ChangeListener)new ChangeListener<Value_Color_Component>(){

            public void changed(ObservableValue<? extends Value_Color_Component> observable, Value_Color_Component oldValue, Value_Color_Component newValue) {
                MoreValueComponent.this.resize();
            }
        });
        this.valueBottomProperty.set((Object)new Value_Color_Component(""));
        this.valueBottomProperty.addListener((ChangeListener)new ChangeListener<Value_Color_Component>(){

            public void changed(ObservableValue<? extends Value_Color_Component> observable, Value_Color_Component oldValue, Value_Color_Component newValue) {
                MoreValueComponent.this.resize();
            }
        });
    }

    @Override
    protected void reColoredComponent() {
        if (this.getTransparenceCheckBoxProperty().get()) {
            this.base_background_component.setStroke((Paint)Color.web((String)"#00000000"));
        } else {
            this.base_background_component.setStroke((Paint)this.baseColor.get());
        }
        this.button_down.setBaseColor((Color)this.baseColor.get());
        this.button_up.setBaseColor((Color)this.baseColor.get());
        this.resize();
    }

    @Override
    protected void resize() {
        this.width_component = this.getWidth();
        this.height_component = this.getHeight();
        this.base_background_component.setWidth(this.width_component);
        this.base_background_component.setHeight(this.height_component);
        this.base_background_component.setArcWidth(this.width_component * 0.044444444444444446);
        this.base_background_component.setArcHeight(this.width_component * 0.044444444444444446);
        this.base_background_component.setStrokeWidth(this.width_component * 0.022222222222222223);
        LinearGradient lg = new LinearGradient(this.width_component * 0.8452471254888888, this.height_component * 1.03818700626, this.width_component * 0.15475287451111114, this.height_component * -0.03818700626, false, CycleMethod.NO_CYCLE, (Stop[])this.stopMap.get((Object)AValueComponent.StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT));
        this.base_background_component.setFill((Paint)lg);
        double previous_w = this.textCanvas.getWidth();
        double previous_h = this.textCanvas.getHeight();
        double newX = this.width_component * 0.03911901127777778;
        double newY = this.height_component * 0.33381546094000003;
        double newWidth = this.width_component * 0.9386587666222223;
        double newHeight = this.height_component * 0.32;
        this.textCanvas.setWidth(newWidth);
        this.textCanvas.setHeight(newHeight);
        this.textCanvas.relocate(newX, newY);
        this.refreshTextContent(previous_w, previous_h, this.textCanvas, this.valueProperty);
        previous_w = this.topCanvas.getWidth();
        previous_h = this.topCanvas.getHeight();
        newX = this.width_component * 0.03911901127777778;
        newY = this.height_component * 0.09176343978;
        newWidth = this.width_component * 0.9309931590666664;
        newHeight = this.height_component * 0.22;
        this.topCanvas.setWidth(newWidth);
        this.topCanvas.setHeight(newHeight);
        this.topCanvas.relocate(newX, newY);
        this.refreshTextContent(previous_w, previous_h, this.topCanvas, this.valueTopProperty);
        previous_w = this.bottomCanvas.getWidth();
        previous_h = this.bottomCanvas.getHeight();
        newX = this.width_component * 0.04295181506666667;
        newY = this.height_component * 0.67383772251;
        newWidth = this.width_component * 0.9309931590666666;
        newHeight = this.height_component * 0.22;
        this.bottomCanvas.setWidth(newWidth);
        this.bottomCanvas.setHeight(newHeight);
        this.bottomCanvas.relocate(newX, newY);
        this.refreshTextContent(previous_w, previous_h, this.bottomCanvas, this.valueBottomProperty);
        this.button_down.refreshSize(this.width_component, this.height_component);
        this.button_up.refreshSize(this.width_component, this.height_component);
    }

    private void refreshTextContent(double previous_w, double previous_h, Canvas canvas, SimpleObjectProperty<Value_Color_Component> simpleObjectProperty) {
        GraphicsContext gc = canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, previous_w, previous_h);
        Font fontLcd = Font.font((String)"Verdana", (double)10.0);
        Bounds maxTextAbmasseLCD = UIToolBox.getMaxTextWidth(fontLcd, ((Value_Color_Component)simpleObjectProperty.get()).getValue());
        double tempSizeLCD = maxTextAbmasseLCD.getWidth() < canvas.getWidth() * 0.97 && maxTextAbmasseLCD.getHeight() < canvas.getHeight() * 0.97 ? UIToolBox.getGreaterFont(fontLcd.getSize() + 1.0, canvas.getWidth() * 0.97, canvas.getHeight() * 0.97, ((Value_Color_Component)simpleObjectProperty.get()).getValue(), 0.01, fontLcd) : UIToolBox.getLesserFont(fontLcd.getSize(), canvas.getWidth() * 0.97, canvas.getHeight() * 0.97, ((Value_Color_Component)simpleObjectProperty.get()).getValue(), 0.01, fontLcd);
        fontLcd = Font.font((String)fontLcd.getName(), (double)tempSizeLCD);
        if (((Value_Color_Component)simpleObjectProperty.get()).getColor() == null) {
            gc.setFill((Paint)this.baseColor.get());
        } else {
            gc.setFill((Paint)((Value_Color_Component)simpleObjectProperty.get()).getColor());
        }
        gc.setFont(fontLcd);
        Text valueText = new Text();
        valueText.setText(((Value_Color_Component)simpleObjectProperty.get()).getValue());
        valueText.setFont(fontLcd);
        double masseinheitXLCD = canvas.getWidth() * 0.97 - valueText.getLayoutBounds().getWidth();
        gc.fillText(valueText.getText(), masseinheitXLCD / 2.0, valueText.getLayoutBounds().getHeight());
    }

    public SimpleObjectProperty<Value_Color_Component> getValueProperty() {
        return this.valueProperty;
    }

    public SimpleObjectProperty<Value_Color_Component> getTopValueProperty() {
        return this.valueTopProperty;
    }

    public SimpleObjectProperty<Value_Color_Component> getBottomValueProperty() {
        return this.valueBottomProperty;
    }
}

