/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javafx.scene.image.Image;

public class ImageLoader {
    public static String ICONS = "/resources/icons";
    public static String SUFFIX_FILE = ".png";

    public static InputStream getResourceStream(String pkname, String fname) throws FileNotFoundException {
        String resname = "" + pkname + "/" + fname;
        File file = new File("");
        file = new File(file.getAbsoluteFile() + resname);
        FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());
        return inputStream;
    }

    public static Image getImageFromIconFolder(String fileName) {
        Image image = null;
        fileName = ImageLoader.checkSuffixFromImageFilename(fileName);
        try {
            InputStream ins = ImageLoader.getResourceStream(ICONS, fileName);
            image = new Image(ins);
            ins.close();
        }
        catch (Exception e) {
            return ImageLoader.getImageFromIconFolder("spacer.png");
        }
        return image;
    }

    public static Image getImageFromIconFolder(String fileName, double newW, double newH, boolean preservationRatio, boolean smooth) {
        Image image = null;
        fileName = ImageLoader.checkSuffixFromImageFilename(fileName);
        try {
            InputStream ins = ImageLoader.getResourceStream(ICONS, fileName);
            image = new Image(ins, newW, newH, preservationRatio, smooth);
            ins.close();
        }
        catch (Exception e) {
            return ImageLoader.getImageFromIconFolder("spacer.png");
        }
        return image;
    }

    protected static String checkSuffixFromImageFilename(String fileName) {
        if (!fileName.contains(SUFFIX_FILE)) {
            fileName = fileName + SUFFIX_FILE;
        }
        return fileName;
    }
}

