/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.component.sensor;

import eu.matfx.component.ButtonRectangle;
import eu.matfx.tools.Command;
import eu.matfx.tools.ImageLoader;
import eu.matfx.tools.UIToolBox;
import java.util.HashMap;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class SingleValueImageComponent
extends Region {
    private HashMap<StopIndizes, Stop[]> stopMap = new HashMap();
    private Rectangle base_background_component;
    private Canvas textCanvas;
    private Canvas imageCanvas;
    private double width_component = 90.0;
    private double height_component = 100.0;
    protected ButtonRectangle button_down;
    protected ButtonRectangle button_up;
    private SimpleStringProperty valueProperty = new SimpleStringProperty();
    private SimpleStringProperty imageFileNameProperty = new SimpleStringProperty();
    private SimpleObjectProperty<Command> commandProperty = new SimpleObjectProperty();
    private SimpleIntegerProperty blurRadiusProperty = new SimpleIntegerProperty();
    private int MIN_BLUR_RADIUS = 0;
    private int MAX_BLUR_RADIUS = 10;
    private int MIN_GRADIENT_ALPHA_CHANNEL = 0;
    private int MAX_GRADIENT_ALPHA_CHANNEL = 128;
    private SimpleIntegerProperty alphaChannelProperty = new SimpleIntegerProperty();
    private SimpleObjectProperty<Color> baseColor = new SimpleObjectProperty();

    public SingleValueImageComponent() {
        this.initGraphics();
        this.registerListener();
    }

    private void initGraphics() {
        this.baseColor.set((Object)Color.web((String)"#5abaa0"));
        this.baseColor.addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                SingleValueImageComponent.this.reColoredComponent();
            }
        });
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.web((String)"#ffffff00")), new Stop(1.0, Color.web((String)"#ffffff33"))};
        this.stopMap.put(StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT, stopArray);
        this.alphaChannelProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != null) {
                    double alphaValueAsDouble = 0.0;
                    if (newValue.intValue() > 0) {
                        alphaValueAsDouble = (double)newValue.intValue() / 255.0;
                    }
                    Stop endStop = ((Stop[])SingleValueImageComponent.this.stopMap.get((Object)StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT))[1];
                    Color colorValue = endStop.getColor();
                    String webColorString = UIToolBox.getWebColorString(colorValue.getRed(), colorValue.getGreen(), colorValue.getBlue(), alphaValueAsDouble);
                    ((Stop[])((SingleValueImageComponent)SingleValueImageComponent.this).stopMap.get((Object)((Object)StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT)))[1] = new Stop(1.0, Color.web((String)webColorString));
                    if (SingleValueImageComponent.this.base_background_component != null) {
                        SingleValueImageComponent.this.resize();
                    }
                }
            }
        });
        this.alphaChannelProperty.set(51);
        this.base_background_component = new Rectangle();
        this.base_background_component.setStroke((Paint)this.baseColor.get());
        this.blurRadiusProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != null) {
                    if (newValue.intValue() < SingleValueImageComponent.this.MIN_BLUR_RADIUS) {
                        newValue = new Integer(SingleValueImageComponent.this.MIN_BLUR_RADIUS);
                    } else if (newValue.intValue() > SingleValueImageComponent.this.MAX_BLUR_RADIUS) {
                        newValue = new Integer(SingleValueImageComponent.this.MAX_BLUR_RADIUS);
                    }
                    GaussianBlur g = new GaussianBlur();
                    g.setRadius((double)newValue.intValue());
                    SingleValueImageComponent.this.base_background_component.setEffect((Effect)g);
                }
            }
        });
        this.blurRadiusProperty.set(4);
        this.textCanvas = new Canvas();
        this.imageCanvas = new Canvas();
        this.button_down = new ButtonRectangle(ButtonRectangle.PositionGradient.FROM_UP_TO_DOWN, 0.23555555562222225, 0.92000000001, 0.5288888887222222, 0.07999999995, 0.022222222222222223);
        this.button_down.setFill((Paint)this.baseColor.get());
        this.button_down.getCommandProperty().addListener((ChangeListener)new ChangeListener<ButtonRectangle.Command>(){

            public void changed(ObservableValue<? extends ButtonRectangle.Command> observable, ButtonRectangle.Command oldValue, ButtonRectangle.Command newValue) {
                if (newValue == ButtonRectangle.Command.BUTTON_RELEASED) {
                    SingleValueImageComponent.this.commandProperty.set((Object)Command.RESET_COMMAND);
                    SingleValueImageComponent.this.commandProperty.set((Object)Command.NEXT_SENSOR_VALUE);
                }
            }
        });
        this.button_up = new ButtonRectangle(ButtonRectangle.PositionGradient.FROM_DOWN_TO_UP, 0.23555555563333336, 0.0, 0.5288888887222222, 0.07999999995, 0.022222222222222223);
        this.button_up.setFill((Paint)this.baseColor.get());
        this.button_up.getCommandProperty().addListener((ChangeListener)new ChangeListener<ButtonRectangle.Command>(){

            public void changed(ObservableValue<? extends ButtonRectangle.Command> observable, ButtonRectangle.Command oldValue, ButtonRectangle.Command newValue) {
                if (newValue == ButtonRectangle.Command.BUTTON_RELEASED) {
                    SingleValueImageComponent.this.commandProperty.set((Object)Command.RESET_COMMAND);
                    SingleValueImageComponent.this.commandProperty.set((Object)Command.PREVIOUS_SENSOR_VALUE);
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.base_background_component, this.textCanvas, this.imageCanvas, this.button_down, this.button_up});
        this.imageFileNameProperty.set("");
        this.valueProperty.set("");
        this.valueProperty.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SingleValueImageComponent.this.resize();
            }
        });
    }

    private void registerListener() {
        this.widthProperty().addListener(observable -> this.resize());
        this.heightProperty().addListener(observable -> this.resize());
    }

    private void resize() {
        this.width_component = this.getWidth();
        this.height_component = this.getHeight();
        this.base_background_component.setWidth(this.width_component);
        this.base_background_component.setHeight(this.height_component);
        this.base_background_component.setArcWidth(this.width_component * 0.044444444444444446);
        this.base_background_component.setArcHeight(this.width_component * 0.044444444444444446);
        this.base_background_component.setStrokeWidth(this.width_component * 0.022222222222222223);
        LinearGradient lg = new LinearGradient(this.width_component * 0.8452471254888888, this.height_component * 1.03818700626, this.width_component * 0.15475287451111114, this.height_component * -0.03818700626, false, CycleMethod.NO_CYCLE, this.stopMap.get((Object)StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT));
        this.base_background_component.setFill((Paint)lg);
        double newX = this.width_component * 0.23555555562222225;
        double newY = this.height_component * 0.09619787962;
        double refresh_w_i = this.imageCanvas.getWidth();
        double refresh_h_i = this.imageCanvas.getHeight();
        double newWidth = this.width_component * 0.5288888887333334;
        double newHeight = this.height_component * 0.27541007289999997;
        this.imageCanvas.setWidth(newWidth);
        this.imageCanvas.setHeight(newHeight);
        this.imageCanvas.relocate(newX, newY);
        this.refreshImageContent(refresh_w_i, refresh_h_i);
        double refresh_w = this.textCanvas.getWidth();
        double refresh_h = this.textCanvas.getHeight();
        newX = this.width_component * 0.01666649998888889;
        newY = this.height_component * 0.38780583212999997;
        newWidth = this.width_component * 0.966667;
        newHeight = this.height_component * 0.51865887269;
        this.textCanvas.setWidth(newWidth);
        this.textCanvas.setHeight(newHeight);
        this.textCanvas.relocate(newX, newY);
        this.refreshLCDContent(refresh_w, refresh_h);
        this.button_down.refreshSize(this.width_component, this.height_component);
        this.button_up.refreshSize(this.width_component, this.height_component);
    }

    private void refreshImageContent(double previous_w, double previous_h) {
        GraphicsContext gc = this.imageCanvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, previous_w, previous_h);
        double x = this.imageCanvas.getLayoutX();
        double y = this.imageCanvas.getLayoutY();
        double newCanvasWidth = this.imageCanvas.getWidth();
        double newCanvasHeight = this.imageCanvas.getHeight();
        System.out.println("x: " + x + " y: " + y + " w: " + newCanvasWidth + " h: " + newCanvasHeight);
        double middle_x = newCanvasWidth / 2.0;
        double middle_y = newCanvasHeight / 2.0;
        Image rawImage = ImageLoader.getImageFromIconFolder(this.imageFileNameProperty.get());
        double ratio = rawImage.getWidth() / rawImage.getHeight();
        double newIconWidth = newCanvasWidth * 0.9;
        double newIconHeight = newCanvasHeight * 0.9;
        if (ratio == 1.0) {
            if (newCanvasWidth <= newCanvasHeight) {
                newIconHeight = newIconWidth;
            } else {
                newIconWidth = newIconHeight;
            }
        } else if (ratio < 1.0) {
            if (newCanvasWidth <= newCanvasHeight) {
                newIconHeight = newIconWidth / ratio;
            } else {
                newIconWidth = newIconHeight * ratio;
            }
        } else if (ratio > 1.0) {
            if (newCanvasWidth <= newCanvasHeight) {
                newIconHeight = newIconWidth / ratio;
            } else {
                newIconWidth = newIconHeight * ratio;
            }
        }
        double halfedWidth = newIconWidth / 2.0;
        double newXLocation = middle_x - halfedWidth;
        double halfedHeight = newIconHeight / 2.0;
        double newYLocation = middle_y - halfedHeight;
        Image scaledImage = ImageLoader.getImageFromIconFolder(this.imageFileNameProperty.get(), newIconWidth, newIconHeight, false, true);
        Image coloredImage = UIToolBox.getColorizedImage(scaledImage, (Color)this.baseColor.get());
        gc.drawImage(coloredImage, newXLocation, newYLocation);
    }

    private void refreshLCDContent(double previous_w, double previous_h) {
        GraphicsContext gc = this.textCanvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, previous_w, previous_h);
        Font fontLcd = Font.font((String)"Verdana", (double)10.0);
        Bounds maxTextAbmasseLCD = UIToolBox.getMaxTextWidth(fontLcd, this.valueProperty.get());
        double tempSizeLCD = maxTextAbmasseLCD.getWidth() < this.textCanvas.getWidth() * 0.97 && maxTextAbmasseLCD.getHeight() < this.textCanvas.getHeight() * 0.97 ? UIToolBox.getGreaterFont(fontLcd.getSize() + 1.0, this.textCanvas.getWidth() * 0.97, this.textCanvas.getHeight() * 0.97, this.valueProperty.get(), 0.01, fontLcd) : UIToolBox.getLesserFont(fontLcd.getSize(), this.textCanvas.getWidth() * 0.97, this.textCanvas.getHeight() * 0.97, this.valueProperty.get(), 0.01, fontLcd);
        fontLcd = Font.font((String)fontLcd.getName(), (double)tempSizeLCD);
        gc.setFill((Paint)this.baseColor.get());
        gc.setFont(fontLcd);
        Text valueText = new Text();
        valueText.setText(this.valueProperty.get());
        valueText.setFont(fontLcd);
        double masseinheitXLCD = this.textCanvas.getWidth() * 0.97 - valueText.getLayoutBounds().getWidth();
        gc.fillText(valueText.getText(), masseinheitXLCD, valueText.getLayoutBounds().getHeight());
    }

    public SimpleStringProperty getValueProperty() {
        return this.valueProperty;
    }

    public SimpleStringProperty getImageProperty() {
        return this.imageFileNameProperty;
    }

    public SimpleObjectProperty<Command> getCommandProperty() {
        return this.commandProperty;
    }

    public SimpleIntegerProperty getBlurRadiusProperty() {
        return this.blurRadiusProperty;
    }

    public int getMinBlurRadiusValue() {
        return this.MIN_BLUR_RADIUS;
    }

    public int getMaxBlurRadiusValue() {
        return this.MAX_BLUR_RADIUS;
    }

    public double getMinGradientAlphaChannel() {
        return this.MIN_GRADIENT_ALPHA_CHANNEL;
    }

    public double getMaxGradientAlphaChannel() {
        return this.MAX_GRADIENT_ALPHA_CHANNEL;
    }

    public SimpleIntegerProperty getAlphaChannelProperty() {
        return this.alphaChannelProperty;
    }

    public Color getBaseColor() {
        return (Color)this.baseColor.get();
    }

    public void setBaseColor(Color colorSelected) {
        this.baseColor.set((Object)colorSelected);
    }

    private void reColoredComponent() {
        this.base_background_component.setStroke((Paint)this.baseColor.get());
        this.button_down.setBaseColor((Color)this.baseColor.get());
        this.button_up.setBaseColor((Color)this.baseColor.get());
        this.resize();
    }

    public static enum StopIndizes {
        BASE_BACKGROUND_LINEAR_GRADIENT;

    }
}

