/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.tools;

import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

public class UIToolBox {
    public static Node createHorizontalSpacer() {
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    public static Node createVerticalSpacer() {
        Region spacer = new Region();
        VBox.setVgrow((Node)spacer, (Priority)Priority.ALWAYS);
        return spacer;
    }

    public static Bounds textWidth(double size, String valueToShow, Font fontBase) {
        if (fontBase == null) {
            fontBase = Font.font((String)"Verdana", (FontWeight)FontWeight.BOLD, (double)12.0);
        }
        Text text = new Text(valueToShow);
        Font font = Font.font((String)fontBase.getFamily(), (FontWeight)FontWeight.BOLD, (double)size);
        text.setFont(font);
        return text.getBoundsInLocal();
    }

    public static Bounds getMaxTextWidth(Font font, String textToShow) {
        Text valTextMax = new Text(textToShow);
        valTextMax.setFont(font);
        Bounds valMaxBounds = valTextMax.getBoundsInLocal();
        return new BoundingBox(0.0, 0.0, valMaxBounds.getWidth(), valMaxBounds.getHeight());
    }

    public static double getGreaterFont(double fontSize, double w, double h, String valueToShow, double gapPercent, Font font) {
        double gapBreite = w * gapPercent * 2.0;
        double gapHoehe = h * gapPercent * 2.0;
        Bounds futureBounds = UIToolBox.textWidth(fontSize += 1.0, valueToShow, null);
        if (futureBounds.getHeight() + gapHoehe < h && futureBounds.getWidth() + gapBreite < w) {
            return UIToolBox.getGreaterFont(fontSize, w, h, valueToShow, gapPercent, font);
        }
        return fontSize - 1.0;
    }

    public static double getLesserFont(double fontSize, double w, double h, String valueToShow, double gapPercent, Font font) {
        Bounds futureBounds = UIToolBox.textWidth(fontSize, valueToShow, font);
        double gapBreite = w * gapPercent * 2.0;
        double gapHoehe = h * gapPercent * 2.0;
        if (futureBounds.getHeight() + gapHoehe > h || futureBounds.getWidth() + gapBreite > w) {
            if ((fontSize -= 1.0) <= 0.0) {
                return 1.0;
            }
            return UIToolBox.getLesserFont(fontSize, w, h, valueToShow, gapPercent, font);
        }
        return fontSize;
    }

    public static double getPointRatio(double baseValue, double partValue) {
        return 100.0 / baseValue * partValue / 100.0;
    }

    public static double getAreaRatio(double rectangle_w, double rectangle_h, double circle_radius) {
        return 100.0 / (rectangle_w * rectangle_h) * (Math.pow(circle_radius, 2.0) * Math.PI) / 100.0;
    }

    public static double getRadiusFromRatio(double rectangle_w, double rectangle_h, double radius_ratio) {
        double circle_area = rectangle_w * rectangle_h * radius_ratio;
        double radius = Math.sqrt(circle_area / Math.PI);
        return radius;
    }

    public static Image getScaledImage(Image imageFx, double w, double h) {
        ImageView imageView = new ImageView(imageFx);
        imageView.setFitWidth(w);
        imageView.setFitHeight(h);
        imageView.setPreserveRatio(false);
        return imageView.snapshot(null, null);
    }

    public static Image getColorizedImage(Image imageToRecolor, Color newColor) {
        int maxX = (int)imageToRecolor.getWidth();
        int maxY = (int)imageToRecolor.getHeight();
        PixelReader pixelReader = imageToRecolor.getPixelReader();
        WritableImage writableImage = new WritableImage(maxX, maxY);
        PixelWriter pixelWriter = writableImage.getPixelWriter();
        for (int y = 0; y < maxY; ++y) {
            for (int x = 0; x < maxX; ++x) {
                Color color = pixelReader.getColor(x, y);
                Color blendedColor = new Color(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), color.getOpacity());
                pixelWriter.setColor(x, y, blendedColor);
            }
        }
        return writableImage;
    }

    public static String getWebColorString(double red, double green, double blue, double alpha) {
        StringBuilder sb = new StringBuilder("#");
        String redValue = String.format("%02X", (int)(red * 255.0));
        String greenValue = String.format("%02X", (int)(green * 255.0));
        String blueValue = String.format("%02X", (int)(blue * 255.0));
        String alphaValue = String.format("%02X", (int)(alpha * 255.0));
        sb.append(redValue).append(greenValue).append(blueValue).append(alphaValue);
        return sb.toString();
    }
}

