/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.component.sensor;

import eu.matfx.component.ButtonRectangle;
import eu.matfx.component.sensor.AValueComponent;
import eu.matfx.tools.Command;
import eu.matfx.tools.ImageLoader;
import eu.matfx.tools.UIToolBox;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class SingleValueImageComponent
extends AValueComponent {
    private double width_component = 90.0;
    private double height_component = 100.0;
    private Canvas textCanvas;
    private Canvas imageCanvas;
    private SimpleStringProperty valueProperty = new SimpleStringProperty();
    private SimpleStringProperty imageFileNameProperty = new SimpleStringProperty();
    protected ButtonRectangle button_up;
    protected ButtonRectangle button_down;

    public SingleValueImageComponent() {
        this.initGraphics();
        this.registerListener();
    }

    @Override
    protected void initGraphics() {
        this.textCanvas = new Canvas();
        this.imageCanvas = new Canvas();
        this.button_down = new ButtonRectangle(ButtonRectangle.PositionGradient.FROM_UP_TO_DOWN, 0.23555555562222225, 0.92000000001, 0.5288888887222222, 0.07999999995, 0.022222222222222223);
        this.button_down.setFill((Paint)this.baseColor.get());
        this.button_down.getCommandProperty().addListener((ChangeListener)new ChangeListener<ButtonRectangle.Command>(){

            public void changed(ObservableValue<? extends ButtonRectangle.Command> observable, ButtonRectangle.Command oldValue, ButtonRectangle.Command newValue) {
                if (newValue == ButtonRectangle.Command.BUTTON_RELEASED) {
                    SingleValueImageComponent.this.getCommandProperty().set((Object)Command.RESET_COMMAND);
                    SingleValueImageComponent.this.getCommandProperty().set((Object)Command.NEXT_SENSOR_VALUE);
                }
            }
        });
        this.button_up = new ButtonRectangle(ButtonRectangle.PositionGradient.FROM_DOWN_TO_UP, 0.23555555563333336, 0.0, 0.5288888887222222, 0.07999999995, 0.022222222222222223);
        this.button_up.setFill((Paint)this.baseColor.get());
        this.button_up.getCommandProperty().addListener((ChangeListener)new ChangeListener<ButtonRectangle.Command>(){

            public void changed(ObservableValue<? extends ButtonRectangle.Command> observable, ButtonRectangle.Command oldValue, ButtonRectangle.Command newValue) {
                if (newValue == ButtonRectangle.Command.BUTTON_RELEASED) {
                    SingleValueImageComponent.this.getCommandProperty().set((Object)Command.RESET_COMMAND);
                    SingleValueImageComponent.this.getCommandProperty().set((Object)Command.PREVIOUS_SENSOR_VALUE);
                }
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.base_background_component, this.textCanvas, this.imageCanvas, this.button_down, this.button_up});
        this.imageFileNameProperty.set("");
        this.valueProperty.set("");
        this.valueProperty.addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                SingleValueImageComponent.this.resize();
            }
        });
    }

    @Override
    protected void registerListener() {
        this.widthProperty().addListener(observable -> this.resize());
        this.heightProperty().addListener(observable -> this.resize());
    }

    @Override
    protected void resize() {
        this.width_component = this.getWidth();
        this.height_component = this.getHeight();
        this.base_background_component.setWidth(this.width_component);
        this.base_background_component.setHeight(this.height_component);
        this.base_background_component.setArcWidth(this.width_component * 0.044444444444444446);
        this.base_background_component.setArcHeight(this.width_component * 0.044444444444444446);
        this.base_background_component.setStrokeWidth(this.width_component * 0.022222222222222223);
        LinearGradient lg = new LinearGradient(this.width_component * 0.8452471254888888, this.height_component * 1.03818700626, this.width_component * 0.15475287451111114, this.height_component * -0.03818700626, false, CycleMethod.NO_CYCLE, (Stop[])this.stopMap.get((Object)AValueComponent.StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT));
        this.base_background_component.setFill((Paint)lg);
        double newX = this.width_component * 0.23555555562222225;
        double newY = this.height_component * 0.09619787962;
        double refresh_w_i = this.imageCanvas.getWidth();
        double refresh_h_i = this.imageCanvas.getHeight();
        double newWidth = this.width_component * 0.5288888887333334;
        double newHeight = this.height_component * 0.27541007289999997;
        this.imageCanvas.setWidth(newWidth);
        this.imageCanvas.setHeight(newHeight);
        this.imageCanvas.relocate(newX, newY);
        this.refreshImageContent(refresh_w_i, refresh_h_i);
        double refresh_w = this.textCanvas.getWidth();
        double refresh_h = this.textCanvas.getHeight();
        newX = this.width_component * 0.01666649998888889;
        newY = this.height_component * 0.38780583212999997;
        newWidth = this.width_component * 0.966667;
        newHeight = this.height_component * 0.51865887269;
        this.textCanvas.setWidth(newWidth);
        this.textCanvas.setHeight(newHeight);
        this.textCanvas.relocate(newX, newY);
        this.refreshLCDContent(refresh_w, refresh_h);
        this.button_down.refreshSize(this.width_component, this.height_component);
        this.button_up.refreshSize(this.width_component, this.height_component);
    }

    private void refreshImageContent(double previous_w, double previous_h) {
        GraphicsContext gc = this.imageCanvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, previous_w, previous_h);
        double x = this.imageCanvas.getLayoutX();
        double y = this.imageCanvas.getLayoutY();
        double newCanvasWidth = this.imageCanvas.getWidth();
        double newCanvasHeight = this.imageCanvas.getHeight();
        System.out.println("x: " + x + " y: " + y + " w: " + newCanvasWidth + " h: " + newCanvasHeight);
        double middle_x = newCanvasWidth / 2.0;
        double middle_y = newCanvasHeight / 2.0;
        Image rawImage = ImageLoader.getImageFromIconFolder(this.imageFileNameProperty.get());
        double ratio = rawImage.getWidth() / rawImage.getHeight();
        double newIconWidth = newCanvasWidth * 0.9;
        double newIconHeight = newCanvasHeight * 0.9;
        if (ratio == 1.0) {
            if (newCanvasWidth <= newCanvasHeight) {
                newIconHeight = newIconWidth;
            } else {
                newIconWidth = newIconHeight;
            }
        } else if (ratio < 1.0) {
            if (newCanvasWidth <= newCanvasHeight) {
                newIconHeight = newIconWidth / ratio;
            } else {
                newIconWidth = newIconHeight * ratio;
            }
        } else if (ratio > 1.0) {
            if (newCanvasWidth <= newCanvasHeight) {
                newIconHeight = newIconWidth / ratio;
            } else {
                newIconWidth = newIconHeight * ratio;
            }
        }
        double halfedWidth = newIconWidth / 2.0;
        double newXLocation = middle_x - halfedWidth;
        double halfedHeight = newIconHeight / 2.0;
        double newYLocation = middle_y - halfedHeight;
        Image scaledImage = ImageLoader.getImageFromIconFolder(this.imageFileNameProperty.get(), newIconWidth, newIconHeight, false, true);
        Image coloredImage = UIToolBox.getColorizedImage(scaledImage, (Color)this.baseColor.get());
        gc.drawImage(coloredImage, newXLocation, newYLocation);
    }

    private void refreshLCDContent(double previous_w, double previous_h) {
        GraphicsContext gc = this.textCanvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, previous_w, previous_h);
        Font fontLcd = Font.font((String)"Verdana", (double)10.0);
        Bounds maxTextAbmasseLCD = UIToolBox.getMaxTextWidth(fontLcd, this.valueProperty.get());
        double tempSizeLCD = maxTextAbmasseLCD.getWidth() < this.textCanvas.getWidth() * 0.97 && maxTextAbmasseLCD.getHeight() < this.textCanvas.getHeight() * 0.97 ? UIToolBox.getGreaterFont(fontLcd.getSize() + 1.0, this.textCanvas.getWidth() * 0.97, this.textCanvas.getHeight() * 0.97, this.valueProperty.get(), 0.01, fontLcd) : UIToolBox.getLesserFont(fontLcd.getSize(), this.textCanvas.getWidth() * 0.97, this.textCanvas.getHeight() * 0.97, this.valueProperty.get(), 0.01, fontLcd);
        fontLcd = Font.font((String)fontLcd.getName(), (double)tempSizeLCD);
        gc.setFill((Paint)this.baseColor.get());
        gc.setFont(fontLcd);
        Text valueText = new Text();
        valueText.setText(this.valueProperty.get());
        valueText.setFont(fontLcd);
        double masseinheitXLCD = this.textCanvas.getWidth() * 0.97 - valueText.getLayoutBounds().getWidth();
        gc.fillText(valueText.getText(), masseinheitXLCD, valueText.getLayoutBounds().getHeight());
    }

    public SimpleStringProperty getValueProperty() {
        return this.valueProperty;
    }

    public SimpleStringProperty getImageProperty() {
        return this.imageFileNameProperty;
    }

    @Override
    public Color getBaseColor() {
        return (Color)this.baseColor.get();
    }

    @Override
    public void setBaseColor(Color colorSelected) {
        this.baseColor.set((Object)colorSelected);
    }

    @Override
    protected void reColoredComponent() {
        this.base_background_component.setStroke((Paint)this.baseColor.get());
        this.button_down.setBaseColor((Color)this.baseColor.get());
        this.button_up.setBaseColor((Color)this.baseColor.get());
        this.resize();
    }
}

