/*
 * Decompiled with CFR 0.152.
 */
package eu.matfx.component.sensor;

import eu.matfx.tools.Command;
import eu.matfx.tools.UIToolBox;
import java.util.HashMap;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;

public abstract class AValueComponent
extends Region {
    protected SimpleObjectProperty<Color> baseColor = new SimpleObjectProperty();
    protected SimpleBooleanProperty useTransparenceStrokeColor = new SimpleBooleanProperty(false);
    protected Rectangle base_background_component;
    private int MIN_BLUR_RADIUS = 0;
    private int MAX_BLUR_RADIUS = 10;
    private int MIN_GRADIENT_ALPHA_CHANNEL = 0;
    private int MAX_GRADIENT_ALPHA_CHANNEL = 128;
    private SimpleIntegerProperty alphaChannelProperty = new SimpleIntegerProperty();
    private SimpleIntegerProperty blurRadiusProperty = new SimpleIntegerProperty();
    protected HashMap<StopIndizes, Stop[]> stopMap = new HashMap();
    private SimpleObjectProperty<Command> commandProperty = new SimpleObjectProperty();

    protected AValueComponent() {
        this.baseColor.set((Object)Color.web((String)"#5abaa0"));
        this.baseColor.addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                AValueComponent.this.reColoredComponent();
            }
        });
        this.useTransparenceStrokeColor.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                AValueComponent.this.reColoredComponent();
            }
        });
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.web((String)"#ffffff00")), new Stop(1.0, Color.web((String)"#ffffff33"))};
        this.stopMap.put(StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT, stopArray);
        this.alphaChannelProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != null) {
                    double alphaValueAsDouble = 0.0;
                    if (newValue.intValue() > 0) {
                        alphaValueAsDouble = (double)newValue.intValue() / 255.0;
                    }
                    Stop endStop = AValueComponent.this.stopMap.get((Object)StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT)[1];
                    Color colorValue = endStop.getColor();
                    String webColorString = UIToolBox.getWebColorString(colorValue.getRed(), colorValue.getGreen(), colorValue.getBlue(), alphaValueAsDouble);
                    AValueComponent.this.stopMap.get((Object)((Object)StopIndizes.BASE_BACKGROUND_LINEAR_GRADIENT))[1] = new Stop(1.0, Color.web((String)webColorString));
                    if (AValueComponent.this.base_background_component != null) {
                        AValueComponent.this.resize();
                    }
                }
            }
        });
        this.alphaChannelProperty.set(51);
        this.base_background_component = new Rectangle();
        if (this.useTransparenceStrokeColor.get()) {
            this.base_background_component.setStroke((Paint)Color.web((String)"#00000000"));
        } else {
            this.base_background_component.setStroke((Paint)this.baseColor.get());
        }
        this.blurRadiusProperty.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                if (newValue != null) {
                    if (newValue.intValue() < AValueComponent.this.MIN_BLUR_RADIUS) {
                        newValue = new Integer(AValueComponent.this.MIN_BLUR_RADIUS);
                    } else if (newValue.intValue() > AValueComponent.this.MAX_BLUR_RADIUS) {
                        newValue = new Integer(AValueComponent.this.MAX_BLUR_RADIUS);
                    }
                    GaussianBlur g = new GaussianBlur();
                    g.setRadius((double)newValue.intValue());
                    AValueComponent.this.base_background_component.setEffect((Effect)g);
                }
            }
        });
        this.blurRadiusProperty.set(4);
    }

    protected abstract void initGraphics();

    protected abstract void registerListener();

    protected abstract void reColoredComponent();

    protected abstract void resize();

    public int getMinBlurRadiusValue() {
        return this.MIN_BLUR_RADIUS;
    }

    public int getMaxBlurRadiusValue() {
        return this.MAX_BLUR_RADIUS;
    }

    public int getMinGradientAlphaChannel() {
        return this.MIN_GRADIENT_ALPHA_CHANNEL;
    }

    public int getMaxGradientAlphaChannel() {
        return this.MAX_GRADIENT_ALPHA_CHANNEL;
    }

    public SimpleIntegerProperty getBlurRadiusProperty() {
        return this.blurRadiusProperty;
    }

    public SimpleIntegerProperty getAlphaChannelProperty() {
        return this.alphaChannelProperty;
    }

    public Color getBaseColor() {
        return (Color)this.baseColor.get();
    }

    public void setBaseColor(Color colorSelected) {
        this.baseColor.set((Object)colorSelected);
    }

    public SimpleObjectProperty<Command> getCommandProperty() {
        return this.commandProperty;
    }

    public SimpleBooleanProperty getTransparenceCheckBoxProperty() {
        return this.useTransparenceStrokeColor;
    }

    public static enum StopIndizes {
        BASE_BACKGROUND_LINEAR_GRADIENT;

    }
}

