/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.func.supp.memento;

import eu.lunisolar.magma.basics.Null;
import eu.lunisolar.magma.func.function.from.LOiFunction;
import eu.lunisolar.magma.func.tuple.LPair;

public class LOiFuncMemento<T, R>
implements LOiFunction<T, R> {
    protected R lastValue;
    protected LOiFunction<T, R> function;

    protected LOiFuncMemento(LOiFunction<T, R> function) {
        Null.nonNullArg(function, (String)"function");
        this.function = function;
    }

    protected LOiFuncMemento(R initialValue, LOiFunction<T, R> function) {
        this(function);
        this.lastValue = initialValue;
    }

    public static <T, R> LOiFuncMemento<T, R> mementoOf(LOiFunction<T, R> supplier) {
        return new LOiFuncMemento<T, R>(supplier);
    }

    public R applyX(T a1, int a2) {
        this.lastValue = this.function.apply(a1, a2);
        return this.lastValue;
    }

    public R lastValue() {
        return this.lastValue;
    }

    public static boolean argEquals(LOiFuncMemento the, Object that) {
        return Null.equals((Object)the, (Object)that, (one, two) -> {
            if (one.getClass() != two.getClass()) {
                return false;
            }
            LOiFuncMemento other = (LOiFuncMemento)two;
            return LPair.argEquals(one.function, one.lastValue(), other.function, other.lastValue());
        });
    }

    public boolean equals(Object that) {
        return LOiFuncMemento.argEquals(this, that);
    }

    public int hashCode() {
        return LPair.argHashCode(this.function, this.lastValue);
    }
}

