/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.func.supp.memento;

import eu.lunisolar.magma.basics.Null;
import eu.lunisolar.magma.func.function.LFunction;
import eu.lunisolar.magma.func.tuple.LPair;

public class LFuncMemento<T, R>
implements LFunction<T, R> {
    protected R lastValue;
    protected LFunction<T, R> function;

    protected LFuncMemento(LFunction<T, R> function) {
        Null.nonNullArg(function, (String)"function");
        this.function = function;
    }

    protected LFuncMemento(R initialValue, LFunction<T, R> function) {
        this(function);
        this.lastValue = initialValue;
    }

    public static <T, R> LFuncMemento<T, R> mementoOf(LFunction<T, R> supplier) {
        return new LFuncMemento<T, R>(supplier);
    }

    public R applyX(T a) {
        this.lastValue = this.function.apply(a);
        return this.lastValue;
    }

    public R lastValue() {
        return this.lastValue;
    }

    public static boolean argEquals(LFuncMemento the, Object that) {
        return Null.equals((Object)the, (Object)that, (one, two) -> {
            if (one.getClass() != two.getClass()) {
                return false;
            }
            LFuncMemento other = (LFuncMemento)two;
            return LPair.argEquals(one.function, one.lastValue(), other.function, other.lastValue());
        });
    }

    public boolean equals(Object that) {
        return LFuncMemento.argEquals(this, that);
    }

    public int hashCode() {
        return LPair.argHashCode(this.function, this.lastValue);
    }
}

