/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.func.supp.memento;

import eu.lunisolar.magma.basics.Null;
import eu.lunisolar.magma.func.function.LBiFunction;
import eu.lunisolar.magma.func.tuple.LPair;

public class LBiFuncMemento<T1, T2, R>
implements LBiFunction<T1, T2, R> {
    protected R lastValue;
    protected LBiFunction<T1, T2, R> function;

    protected LBiFuncMemento(LBiFunction<T1, T2, R> function) {
        Null.nonNullArg(function, (String)"function");
        this.function = function;
    }

    protected LBiFuncMemento(R initialValue, LBiFunction<T1, T2, R> function) {
        this(function);
        this.lastValue = initialValue;
    }

    public static <T1, T2, R> LBiFuncMemento<T1, T2, R> mementoOf(LBiFunction<T1, T2, R> supplier) {
        return new LBiFuncMemento<T1, T2, R>(supplier);
    }

    public R applyX(T1 a1, T2 a2) {
        this.lastValue = this.function.apply(a1, a2);
        return this.lastValue;
    }

    public R lastValue() {
        return this.lastValue;
    }

    public static boolean argEquals(LBiFuncMemento the, Object that) {
        return Null.equals((Object)the, (Object)that, (one, two) -> {
            if (one.getClass() != two.getClass()) {
                return false;
            }
            LBiFuncMemento other = (LBiFuncMemento)two;
            return LPair.argEquals(one.function, one.lastValue(), other.function, other.lastValue());
        });
    }

    public boolean equals(Object that) {
        return LBiFuncMemento.argEquals(this, that);
    }

    public int hashCode() {
        return LPair.argHashCode(this.function, this.lastValue);
    }
}

