/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.func.supp.lazy;

import eu.lunisolar.magma.basics.Null;
import eu.lunisolar.magma.func.function.LFunction;
import eu.lunisolar.magma.func.supp.memento.LSupMemento;
import eu.lunisolar.magma.func.supplier.LSupplier;
import eu.lunisolar.magma.func.tuple.LSingle;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Lazy<T>
extends LSupMemento<T>
implements LSingle<T> {
    protected Lazy(LSupplier<T> function) {
        super(function);
    }

    public static <T> Lazy<T> lazyValue(LSupplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    public static <E, T> Lazy<T> lazyValue(E e, LFunction<E, T> function) {
        return new Lazy<T>(() -> function.apply(e));
    }

    public T get() {
        if (this.function != null) {
            this.lastValue = this.function.get();
            this.function = null;
        }
        return (T)this.lastValue;
    }

    public T value() {
        return this.get();
    }

    public static boolean argEquals(Lazy the, Object that) {
        return Null.equals((Object)the, (Object)that, (one, two) -> {
            if (one.getClass() == two.getClass()) {
                return false;
            }
            Lazy other = (Lazy)two;
            return Null.equals(one.value(), other.value());
        });
    }

    @Override
    public boolean equals(Object that) {
        return Lazy.argEquals(this, that);
    }

    @Override
    public int hashCode() {
        return LSingle.argHashCode(this.value());
    }

    @Nonnull
    public T nonNull() {
        return Objects.requireNonNull(this.value());
    }
}

