/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.basics.asserts;

import eu.lunisolar.magma.basics.Null;
import eu.lunisolar.magma.basics.asserts.AbstractEvaluation;
import eu.lunisolar.magma.basics.asserts.AssertionFunction;
import eu.lunisolar.magma.basics.asserts.FullFunctionalAssert;
import eu.lunisolar.magma.func.supp.check.Checks;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.assertj.core.api.Assert;
import org.assertj.core.api.Condition;

@Immutable
@ThreadSafe
public final class Evaluation<CTX extends FullFunctionalAssert<CTX, PC, A, RS, R>, PC, A, RS extends Assert<RS, R>, R>
extends AbstractEvaluation<Evaluation<CTX, PC, A, RS, R>, CTX, PC, RS> {
    public Evaluation(@Nonnull CTX context, @Nonnull Supplier<String> description, @Nonnull Supplier<String> caseDescription, @Nonnull AssertionFunction<PC, RS> assertFunction, @Nullable List<Consumer<RS>> assertPreConsumer) {
        super(context, description, caseDescription, assertFunction, assertPreConsumer);
    }

    private R stillActualResult() {
        final AtomicReference reference = new AtomicReference();
        this.to(rs -> rs.satisfies(new Condition<R>(){

            public boolean matches(R value) {
                reference.set(value);
                return true;
            }
        }));
        return (R)reference.get();
    }

    public CTX to(@Nonnull Consumer<RS> assertions) {
        Evaluation.normalCheck(this.description, this.caseDescription, this.preconditioner, this.assertFunction, this.assertPreConsumer, assertions);
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public CTX toEqualTo(R equalsTo) {
        this.to(rs -> rs.isEqualTo(equalsTo));
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public CTX as(@Nonnull Consumer<RS> assertions) {
        return this.to(assertions);
    }

    public CTX asEqualTo(R equalsTo) {
        this.to(rs -> rs.isEqualTo(equalsTo));
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public CTX that(@Nonnull Consumer<R> customCheckBlock) {
        Null.nonNullArg(customCheckBlock, (String)"customCheckBlock");
        R actualResult = this.stillActualResult();
        customCheckBlock.accept(actualResult);
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public CTX toEx(@Nonnull Consumer<Checks.Check<R>> customCheckBlock) {
        Null.nonNullArg(customCheckBlock, (String)"customCheckBlock");
        R actualResult = this.stillActualResult();
        customCheckBlock.accept(Checks.attest(actualResult));
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public <AA> CTX that(@Nonnull Function<R, AA> adapter, @Nonnull Consumer<AA> customCheckBlock) {
        Null.nonNullArg(adapter, (String)"adapter");
        Null.nonNullArg(customCheckBlock, (String)"customCheckBlock");
        R actualResult = this.stillActualResult();
        AA wrapper = adapter.apply(actualResult);
        Null.nonNull(wrapper, () -> "Adapter function must produce non-null result!");
        customCheckBlock.accept(wrapper);
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public <V, AA> CTX that(@Nonnull BiFunction<R, V, AA> adapter, @Nullable V adapterParam, @Nonnull Consumer<AA> customCheckBlock) {
        Null.nonNullArg(adapter, (String)"adapter");
        Null.nonNullArg(customCheckBlock, (String)"customCheckBlock");
        R actualResult = this.stillActualResult();
        AA wrapper = adapter.apply(actualResult, adapterParam);
        Null.nonNull(wrapper, () -> "Adapter function must produce non-null result!");
        customCheckBlock.accept(wrapper);
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }
}

