/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.basics.perf;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.profile.HotspotMemoryProfiler;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;

public class JMH {
    private ChainedOptionsBuilder opt = new OptionsBuilder();

    public JMH() {
        this.opt.verbosity(VerboseMode.EXTRA).syncIterations(true).forks(1).resultFormat(ResultFormatType.TEXT);
    }

    public static JMH jmh() {
        return new JMH();
    }

    public JMH java8ServerArgs() {
        this.opt.jvmArgs(new String[]{"-server", "-XX:+UseTLAB", "-XX:+AggressiveOpts", "-XX:+UseBiasedLocking", "-XX:+UseFastAccessorMethods"});
        return this;
    }

    public JMH java10ServerArgs() {
        this.opt.jvmArgs(new String[]{"-server", "-XX:+UseTLAB", "-XX:+AggressiveOpts", "-XX:+UseBiasedLocking"});
        return this;
    }

    public JMH iterations(int warmupTimes, TimeValue warmupDuration, int measurementsTimes, TimeValue measurementsDurations) {
        this.opt.warmupIterations(warmupTimes).warmupTime(warmupDuration).measurementIterations(measurementsTimes).measurementTime(measurementsDurations);
        return this;
    }

    public JMH opt(Consumer<ChainedOptionsBuilder> options) {
        options.accept(this.opt);
        return this;
    }

    public JMH classes(Class ... testClass) {
        for (Class c : testClass) {
            this.opt.include(c.getSimpleName());
        }
        return this;
    }

    public JMH param(String name, String ... values) {
        this.opt.param(name, values);
        return this;
    }

    public JMH mode(Mode mode) {
        this.opt.mode(mode);
        return this;
    }

    public JMH timeUnit(TimeUnit unit) {
        this.opt.timeUnit(unit);
        return this;
    }

    public JMH gc() {
        this.opt.addProfiler(GCProfiler.class);
        return this;
    }

    public JMH mem() {
        this.opt.addProfiler(HotspotMemoryProfiler.class);
        return this;
    }

    public void run() {
        try {
            new Runner(this.opt.build()).run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

