/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.basics.asserts;

import eu.lunisolar.magma.basics.asserts.AbstractEvaluation;
import eu.lunisolar.magma.basics.asserts.AssertionFunction;
import eu.lunisolar.magma.basics.asserts.FullFunctionalAssert;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.assertj.core.api.Assert;

@Immutable
@ThreadSafe
public final class Evaluation<CTX extends FullFunctionalAssert<CTX, PC, A, RS, R>, PC, A, RS extends Assert<RS, R>, R>
extends AbstractEvaluation<Evaluation<CTX, PC, A, RS, R>, CTX, PC, RS> {
    public Evaluation(@Nonnull CTX context, @Nonnull Supplier<String> description, @Nonnull Supplier<String> caseDescription, @Nonnull AssertionFunction<PC, RS> assertFunction, @Nullable Consumer<RS> assertPreConsumer) {
        super(context, description, caseDescription, assertFunction, assertPreConsumer);
    }

    public CTX to(@Nonnull Consumer<RS> assertions) {
        Evaluation.normalCheck(this.description, this.caseDescription, this.preconditioner, this.assertFunction, this.assertPreConsumer, assertions);
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public CTX toEqualTo(R equalsTo) {
        this.to(rs -> rs.isEqualTo(equalsTo));
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }

    public CTX as(@Nonnull Consumer<RS> assertions) {
        return this.to(assertions);
    }

    public CTX asEqualTo(R equalsTo) {
        this.to(rs -> rs.isEqualTo(equalsTo));
        return (CTX)((FullFunctionalAssert)((FullFunctionalAssert)this.context).self());
    }
}

