/*
 * Decompiled with CFR 0.152.
 */
package eu.lunisolar.magma.basics.asserts;

import eu.lunisolar.magma.basics.asserts.AssertionFunction;
import eu.lunisolar.magma.basics.asserts.AssertionsCheck;
import eu.lunisolar.magma.basics.fluent.Fluent;
import eu.lunisolar.magma.basics.fluent.FluentSubcontext;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;

@Immutable
@ThreadSafe
public abstract class AbstractEvaluation<SELF extends AbstractEvaluation<SELF, CTX, PC, A>, CTX extends Fluent<CTX>, PC, A>
implements FluentSubcontext<SELF, CTX> {
    @Nonnull
    protected Supplier<String> description;
    @Nonnull
    protected Supplier<String> caseDescription;
    @Nullable
    protected PC preconditioner;
    @Nonnull
    protected final AssertionFunction<PC, A> assertFunction;
    @Nullable
    protected final Consumer<A> assertPreConsumer;
    @Nonnull
    protected final CTX context;

    protected AbstractEvaluation(@Nonnull CTX context, @Nonnull Supplier<String> description, @Nonnull Supplier<String> caseDescription, @Nonnull AssertionFunction<PC, A> assertFunction, @Nullable Consumer<A> assertPreConsumer) {
        this.description = description;
        this.caseDescription = caseDescription;
        this.assertPreConsumer = assertPreConsumer;
        this.assertFunction = Objects.requireNonNull(assertFunction);
        this.context = context;
    }

    protected AbstractEvaluation(@Nonnull CTX context, @Nonnull Supplier<String> description, @Nonnull Supplier<String> caseDescription, @Nullable AssertionsCheck assertPreConsumer, AssertionFunction<PC, A> assertFunction) {
        this(context, description, caseDescription, assertFunction, assertPreConsumer == null ? null : a -> assertPreConsumer.assertionsCheck());
    }

    public SELF when(PC preconditioner) {
        this.preconditioner = preconditioner;
        return (SELF)((AbstractEvaluation)this.self());
    }

    public CTX soThat(@Nonnull AssertionsCheck assertions) {
        AbstractEvaluation.normalCheck(this.description, this.caseDescription, this.preconditioner, this.assertFunction, this.assertPreConsumer, a -> assertions.assertionsCheck());
        return (CTX)((Fluent)this.context.self());
    }

    public CTX withoutException() {
        AbstractEvaluation.exceptionCheck(this.description, this.caseDescription, this.preconditioner, this.assertFunction, a -> {});
        return (CTX)((Fluent)this.context.self());
    }

    public CTX withException(@Nonnull Consumer<AbstractThrowableAssert<?, ? extends Throwable>> assertions) {
        AbstractEvaluation.exceptionCheck(this.description, this.caseDescription, this.preconditioner, this.assertFunction, assertions);
        return (CTX)((Fluent)this.context.self());
    }

    protected static <PC, A, X extends Throwable> void normalCheck(@Nonnull Supplier<String> description, @Nonnull Supplier<String> caseDescription, @Nullable PC preconditioner, @Nonnull AssertionFunction<PC, A> assertFunction, @Nullable Consumer<A> assertPreConsumer, @Nonnull Consumer<A> assertConsumer) {
        try {
            A resultAssert = assertFunction.applyAndCreateResultAssert(preconditioner);
            try {
                if (assertPreConsumer != null) {
                    assertPreConsumer.accept(resultAssert);
                }
            }
            catch (AssertionError e) {
                throw new AssertionError(String.format("%sRecurring assertion failed.%s", AbstractEvaluation.mainDescription(description), ((Throwable)((Object)e)).getMessage()), (Throwable)((Object)e));
            }
            assertConsumer.accept(resultAssert);
        }
        catch (AssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            Fail.fail((String)String.format("%sCase %s should evaluate without problem.", AbstractEvaluation.mainDescription(description), caseDescription.get()), (Throwable)e);
        }
    }

    protected static <PC, A, X extends Throwable> void exceptionCheck(@Nonnull Supplier<String> description, @Nonnull Supplier<String> caseDescription, @Nullable PC preconditioner, @Nonnull AssertionFunction<PC, A> assertFunction, @Nonnull Consumer<AbstractThrowableAssert<?, ? extends Throwable>> assertConsumer) {
        try {
            assertFunction.applyAndCreateResultAssert(preconditioner);
        }
        catch (Throwable e) {
            assertConsumer.accept((AbstractThrowableAssert<?, Throwable>)Assertions.assertThat((Throwable)e).as(description.get(), new Object[0]));
            return;
        }
        Fail.fail((String)"%sCase %s should evaluate with exception.", (Object[])new Object[]{AbstractEvaluation.mainDescription(description), caseDescription.get()});
    }

    private static String mainDescription(@Nonnull Supplier<String> description) {
        String desc = description.get();
        desc = desc == null ? "" : desc;
        desc = desc.isEmpty() ? desc : "[" + desc + "] ";
        return desc;
    }
}

