/*
 * Decompiled with CFR 0.152.
 */
package eu.lundegaard.maven.finddeps;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="find-deps", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class FindDepsMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(FindDepsMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter
    private List<String> includeOnlyRepoIds = new ArrayList<String>();
    @Parameter
    private List<String> includeOnlyRepoUrls = new ArrayList<String>();
    @Parameter
    private List<String> excludedRepoIds = new ArrayList<String>();
    @Parameter
    private List<String> excludedRepoUrls = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.doExecute();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error while running plugin.", (Throwable)e);
        }
        catch (TemplateException te) {
            throw new MojoExecutionException("Error while running plugin.", (Exception)((Object)te));
        }
    }

    private void doExecute() throws IOException, TemplateException {
        MavenProject topLevelProject = this.findTopLevelProject(this.session.getTopLevelProject());
        if (this.project.toString().equals(topLevelProject.toString())) {
            List allProjects = this.session.getAllProjects();
            List<Repository> repositories = this.gatherRepositories(allProjects);
            List<Repository> pluginRepositories = this.gatherPluginRepositories(allProjects);
            List<Dependency> dependencies = this.gatherDependencies(allProjects);
            List<Plugin> buildPlugins = this.gatherBuildPlugins(allProjects);
            String pom = this.producePom(repositories, pluginRepositories, dependencies, buildPlugins);
            File depsPomFile = new File(this.project.getBasedir(), "pom-dependencies.xml");
            FileUtils.write((File)depsPomFile, (CharSequence)pom, (Charset)StandardCharsets.UTF_8);
            LOG.info("Dependencies POM file: {}", (Object)depsPomFile);
            LOG.info("Repositories count: {}", (Object)repositories.size());
            LOG.info("Plugin Repositories count: {}", (Object)pluginRepositories.size());
            LOG.info("Dependencies count: {}", (Object)dependencies.size());
            LOG.info("Plugins count: {}", (Object)buildPlugins.size());
        } else {
            LOG.info("Not a top-level project - skipping.");
        }
    }

    private List<Plugin> gatherBuildPlugins(List<MavenProject> projects) {
        return projects.stream().flatMap(p -> p.getBuildPlugins().stream()).filter(FindDepsMojo.distinctByKey(p -> String.join((CharSequence)":", p.getGroupId(), p.getArtifactId(), p.getVersion()))).sorted(Comparator.comparing(Plugin::getGroupId).thenComparing(Plugin::getArtifactId).thenComparing(Plugin::getVersion)).collect(Collectors.toList());
    }

    private List<Repository> gatherRepositories(List<MavenProject> projects) {
        return projects.stream().flatMap(p -> p.getRepositories().stream()).distinct().filter(r -> this.includeOnlyRepoIds.contains(r.getId())).filter(r -> this.includeOnlyRepoUrls.contains(r.getUrl())).filter(r -> !this.excludedRepoIds.contains(r.getId())).filter(r -> !this.excludedRepoUrls.contains(r.getUrl())).collect(Collectors.toList());
    }

    private List<Repository> gatherPluginRepositories(List<MavenProject> projects) {
        return projects.stream().flatMap(p -> p.getPluginRepositories().stream()).distinct().filter(r -> this.includeOnlyRepoIds.contains(r.getId())).filter(r -> this.includeOnlyRepoUrls.contains(r.getUrl())).filter(r -> !this.excludedRepoIds.contains(r.getId())).filter(r -> !this.excludedRepoUrls.contains(r.getUrl())).collect(Collectors.toList());
    }

    private List<Dependency> gatherDependencies(List<MavenProject> projects) {
        return projects.stream().flatMap(p -> p.getDependencies().stream()).filter(dependency -> !dependency.getGroupId().equals(this.project.getGroupId())).filter(FindDepsMojo.distinctByKey(d -> String.join((CharSequence)":", d.getGroupId(), d.getArtifactId(), d.getVersion()))).sorted(Comparator.comparing(Dependency::getGroupId).thenComparing(Dependency::getArtifactId).thenComparing(Dependency::getVersion)).collect(Collectors.toList());
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private String producePom(List<Repository> repositories, List<Repository> pluginRepositories, List<Dependency> dependencies, List<Plugin> plugins) throws IOException, TemplateException {
        Configuration freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_29);
        freemarkerConfiguration.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/templates");
        freemarkerConfiguration.setDefaultEncoding("UTF-8");
        freemarkerConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        freemarkerConfiguration.setLogTemplateExceptions(false);
        freemarkerConfiguration.setWrapUncheckedExceptions(true);
        freemarkerConfiguration.setFallbackOnNullLoopVariable(false);
        freemarkerConfiguration.setWhitespaceStripping(true);
        HashMap<String, Object> freemarkerData = new HashMap<String, Object>();
        freemarkerData.put("project", this.project);
        freemarkerData.put("repositories", repositories);
        freemarkerData.put("pluginRepositories", pluginRepositories);
        freemarkerData.put("dependencies", dependencies);
        freemarkerData.put("plugins", plugins);
        Template template = freemarkerConfiguration.getTemplate("pom-dependencies.xml.ftl");
        StringWriter output = new StringWriter();
        template.process(freemarkerData, (Writer)output);
        return output.toString();
    }

    private MavenProject findTopLevelProject(MavenProject givenProject) {
        MavenProject parentProject = givenProject.getParent();
        if (parentProject == null) {
            return givenProject;
        }
        File parentProjectDir = parentProject.getBasedir();
        if (parentProjectDir == null) {
            return givenProject;
        }
        return this.findTopLevelProject(parentProject);
    }
}

