<#-- @ftlvariable name="project" type="org.apache.maven.project.MavenProject" -->
<#-- @ftlvariable name="repositories" type="java.util.List<org.apache.maven.model.Repository>" -->
<#-- @ftlvariable name="pluginRepositories" type="java.util.List<org.apache.maven.model.Repository>" -->
<#-- @ftlvariable name="dependencies" type="java.util.List<org.apache.maven.model.Dependency>" -->
<#-- @ftlvariable name="plugins" type="java.util.List<org.apache.maven.model.Plugin>" -->
<?xml version="1.0" encoding="UTF-8"?>

<!-- NOTE: Do NOT edit manually. This file is generated by find-deps-maven-plugin. -->

<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd">
    <modelVersion>4.0.0</modelVersion>
    <groupId>${project.groupId}</groupId>
    <artifactId>${project.artifactId}-dependencies</artifactId>
    <version>${project.version}</version>
    <packaging>jar</packaging>
    <name>${project.name} [Dependencies]</name>
    <description>Dependencies POM for the '${project.name}'. Use it together with `mvn dependency:go-offline`.</description>

    <#if repositories?has_content>
    <repositories>
        <#list repositories as repository>
        <repository>
            <id>${repository.id}</id>
            <name>${repository.name}</name>
            <url>${repository.url}</url>
            <#if repository.releases?has_content && repository.releases.getEnabled()?has_content>
            <releases>
                <enabled>${repository.releases.getEnabled()}</enabled>
            </releases>
            </#if>
            <#if repository.snapshots?has_content && repository.snapshots.getEnabled()?has_content>
            <snapshots>
                <enabled>${repository.snapshots.getEnabled()}</enabled>
            </snapshots>
            </#if>
        </repository>
        </#list>
    </repositories>
    </#if>

    <#if pluginRepositories?has_content>
    <pluginRepositories>
        <#list pluginRepositories as repository>
        <pluginRepository>
            <id>${repository.id}</id>
            <name>${repository.name}</name>
            <url>${repository.url}</url>
            <#if repository.releases?has_content && repository.releases.getEnabled()?has_content>
            <releases>
                <enabled>${repository.releases.getEnabled()}</enabled>
            </releases>
            </#if>
            <#if repository.snapshots?has_content && repository.snapshots.getEnabled()?has_content>
            <snapshots>
                <enabled>${repository.snapshots.getEnabled()}</enabled>
            </snapshots>
            </#if>
        </pluginRepository>
        </#list>
    </pluginRepositories>
    </#if>

    <dependencies>
        <#-- Standard dependencies -->
        <#list dependencies as dependency>
        <dependency>
            <groupId>${dependency.groupId}</groupId>
            <artifactId>${dependency.artifactId}</artifactId>
            <version>${dependency.version}</version>
        </dependency>
        </#list>
        <#-- Plugins as dependencies -->
        <#list plugins as plugin>
        <dependency>
            <groupId>${plugin.groupId}</groupId>
            <artifactId>${plugin.artifactId}</artifactId>
            <version>${plugin.version}</version>
        </dependency>
        <#-- And plugins' dependencies -->
        <#list plugin.dependencies as dependency>
        <dependency>
            <groupId>${dependency.groupId}</groupId>
            <artifactId>${dependency.artifactId}</artifactId>
            <version>${dependency.version}</version>
        </dependency>
        </#list>
        </#list>
    </dependencies>

    <build>
        <plugins>
        <#list plugins as plugin>
            <plugin>
                <groupId>${plugin.groupId}</groupId>
                <artifactId>${plugin.artifactId}</artifactId>
                <version>${plugin.version}</version>
                <#if plugin.dependencies?has_content>
                <dependencies>
                    <#list plugin.dependencies as dependency>
                    <dependency>
                        <groupId>${dependency.groupId}</groupId>
                        <artifactId>${dependency.artifactId}</artifactId>
                        <version>${dependency.version}</version>
                    </dependency>
                    </#list>
                </dependencies>
                </#if>
            </plugin>
        </#list>
        </plugins>
    </build>
</project>
