/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.util;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.GetAttributesScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.NodeShutdownHook;
import eu.lindenbaum.maven.erlang.Script;
import eu.lindenbaum.maven.util.CollectionUtils;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.Predicate;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class MojoUtils {
    private static final String WINDOWS = "WINDOWS";
    private static final String EUNIT_TESTS_SUFFIX = "_tests.beam";
    private static final Pattern DIALYZER_WARNING = Pattern.compile("(.+):(\\d+): (.+)");

    public static boolean isWindows() throws MojoExecutionException {
        String property = System.getProperty("os.name");
        if (property != null) {
            return property.toUpperCase().contains(WINDOWS);
        }
        throw new MojoExecutionException("Java property 'os.name' not set.");
    }

    public static void startBackend(final Log log, String cmd, String nodeName, String nodeCookie, final File cwd, final File backendLog) throws MojoExecutionException {
        OtpPeer peer = new OtpPeer(nodeName);
        try {
            try {
                String startupName = "maven-erlang-plugin-startup-" + System.nanoTime();
                OtpSelf self = nodeCookie != null ? new OtpSelf(startupName, nodeCookie) : new OtpSelf(startupName);
                self.connect(peer);
                log.debug((CharSequence)("Node " + peer + " is already running."));
            }
            catch (IOException e) {
                log.debug((CharSequence)("starting " + peer + "."));
                ArrayList<String> command = new ArrayList<String>();
                command.add(cmd);
                command.add("-boot");
                command.add("start_sasl");
                command.add("-name");
                command.add(peer.node());
                command.add("-noshell");
                if (nodeCookie != null) {
                    command.add("-setcookie");
                    command.add(nodeCookie);
                }
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                processBuilder.redirectErrorStream(true);
                final Process process = processBuilder.start();
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        InputStreamReader input = new InputStreamReader(process.getInputStream());
                        BufferedReader reader = new BufferedReader(input);
                        try {
                            PrintWriter writer = new PrintWriter(new FileWriter(backendLog, true));
                            String line = null;
                            try {
                                while ((line = reader.readLine()) != null) {
                                    writer.println(line);
                                }
                            }
                            catch (IOException e) {
                                writer.println("Failed to read node output: " + e);
                            }
                            finally {
                                writer.flush();
                                writer.close();
                            }
                        }
                        catch (Exception e) {
                            log.warn((CharSequence)("Unable to write backend node log file " + backendLog), (Throwable)e);
                        }
                    }
                });
                thread.setDaemon(true);
                thread.start();
                log.debug((CharSequence)("Node " + peer + " sucessfully started."));
                MavenSelf.get(nodeCookie).exec(nodeName, new Script<Void>(){

                    @Override
                    public String get() {
                        return "ok = file:set_cwd(\"" + cwd.getAbsolutePath() + "\").";
                    }

                    @Override
                    public Void handle(OtpErlangObject result) {
                        return null;
                    }
                });
            }
            try {
                Runtime.getRuntime().addShutdownHook(NodeShutdownHook.get(nodeName, nodeCookie));
            }
            catch (IllegalArgumentException e1) {
                log.debug((CharSequence)"shutdown hook already registered.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to start " + peer + ".", (Exception)e);
        }
        catch (OtpAuthException e) {
            throw new MojoExecutionException("Failed to connect to " + peer + ".", (Exception)((Object)e));
        }
    }

    public static boolean newerFilesThan(File reference, Collection<File> dirs) {
        long referenceTime = reference.lastModified();
        if (referenceTime > 0L) {
            ArrayList<File> sources = new ArrayList<File>();
            for (File dir : dirs) {
                sources.addAll(FileUtils.getFilesRecursive(dir, ".erl"));
                sources.addAll(FileUtils.getFilesRecursive(dir, ".hrl"));
            }
            for (File file : sources) {
                if (file.lastModified() <= referenceTime) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static Collection<String> parseDialyzerOutput(String[] output, Collection<File> sources) {
        ArrayList<String> warnings = new ArrayList<String>();
        for (String warning : output) {
            Matcher matcher = DIALYZER_WARNING.matcher(warning);
            if (matcher.matches()) {
                String fileName = matcher.group(1);
                File file = FileUtils.getFile(fileName, sources);
                if (file != null) {
                    warnings.add(" * " + file + ":" + matcher.group(2));
                } else {
                    warnings.add(" * " + fileName + ":" + matcher.group(2));
                }
                warnings.add("   " + matcher.group(3));
                continue;
            }
            warnings.add(" * " + warning);
        }
        return warnings;
    }

    public static List<File> getEunitTestSet(final Collection<File> tests, Collection<File> excludes) {
        ArrayList<File> prefiltered = new ArrayList<File>(tests);
        prefiltered.removeAll(excludes);
        return new ArrayList<File>(CollectionUtils.filter(new Predicate<File>(){

            @Override
            public boolean pred(File object) {
                String testPath = object.getAbsolutePath();
                if (testPath.endsWith(MojoUtils.EUNIT_TESTS_SUFFIX)) {
                    String impl = testPath.replace(MojoUtils.EUNIT_TESTS_SUFFIX, ".beam");
                    return !tests.contains(new File(impl));
                }
                return true;
            }
        }, prefiltered));
    }

    public static Map<String, String> getApplicationReplacements(Properties p) throws MojoExecutionException {
        List<File> modules = p.modules(false, false);
        Set<Artifact> dependencies = MavenUtils.getErlangDependenciesToPackage(p.project());
        GetAttributesScript registeredScript = new GetAttributesScript(modules, "registered");
        String registeredNames = MavenSelf.get(p.cookie()).exec(p.node(), registeredScript);
        Map<String, String> replacements = MavenUtils.getProjectReplacements(p.project(), "'", "\"");
        replacements.put("${MODULES}", ErlUtils.toModuleList(modules, "'", "'"));
        replacements.put("${REGISTERED}", registeredNames);
        replacements.put("${APPLICATIONS}", ErlUtils.toArtifactIdListing(dependencies));
        return replacements;
    }

    public static void emitBackendLogInfo(Log log, File backendLog) {
        if (backendLog.isFile()) {
            log.info((CharSequence)"");
            log.info((CharSequence)"The erlang backend node output is available in:");
            log.info((CharSequence)backendLog.toString());
        }
    }
}

