/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.util;

import eu.lindenbaum.maven.MavenComponents;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.util.CollectionUtils;
import eu.lindenbaum.maven.util.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

public final class MavenUtils {
    public static String SEPARATOR = "------------------------------------------------------------------------";
    public static String FAT_SEPARATOR = "========================================================================";

    public static Set<ArtifactVersion> getAvailableVersions(Artifact artifact, MavenComponents components) throws MojoExecutionException {
        ArtifactMetadataSource source = components.metadataSource();
        ArtifactRepository local = components.localRepository();
        List<ArtifactRepository> remotes = components.remoteRepositories();
        try {
            List retrieved = source.retrieveAvailableVersions(artifact, local, remotes);
            return new HashSet<ArtifactVersion>(retrieved);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException("Failed to get available versions for artifact " + artifact + ".", (Exception)((Object)e));
        }
    }

    public static File getArtifactFile(Artifact artifact, MavenComponents components) throws MojoExecutionException {
        ArtifactResolver artifactResolver = components.artifactResolver();
        List<ArtifactRepository> remoteRepositories = components.remoteRepositories();
        ArtifactRepository localRepository = components.localRepository();
        try {
            artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve artifact " + artifact + ".", e);
        }
        File file = new File(localRepository.getBasedir(), localRepository.pathOf(artifact));
        if (!file.isFile()) {
            throw new MojoExecutionException("Failed to resolve artifact " + artifact + ".");
        }
        return file;
    }

    public static Artifact getArtifact(Artifact from, String version, MavenComponents components) {
        ArtifactFactory factory = components.artifactFactory();
        return factory.createBuildArtifact(from.getGroupId(), from.getArtifactId(), version, from.getType());
    }

    public static VersionRange createVersionRange(String versionSpec) throws MojoExecutionException {
        try {
            return VersionRange.createFromVersionSpec((String)versionSpec);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Failed to create version range.", (Exception)((Object)e));
        }
    }

    public static Set<String> getArtifactIds(Collection<Artifact> artifacts) {
        return new HashSet<String>(CollectionUtils.map(new CollectionUtils.MapFunction<Artifact, String>(){

            @Override
            public String apply(Artifact a) {
                return a.getArtifactId();
            }
        }, artifacts));
    }

    public static String getArtifactDirectory(Artifact artifact) {
        return artifact.getFile().getName().replace("." + artifact.getType(), "").replace(".tar.gz", "");
    }

    public static String getReleaseName(MavenProject project) {
        return project.getArtifactId() + "-" + project.getVersion();
    }

    public static Set<Artifact> getErlangReleaseArtifacts(MavenProject project) {
        return new HashSet<Artifact>(CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                String scope = artifact.getScope();
                return !"test".equals(scope) && !"provided".equals(scope);
            }
        }, MavenUtils.getErlangArtifacts(project)));
    }

    public static Set<Artifact> getErlangDependenciesToPackage(MavenProject project) {
        return new HashSet<Artifact>(CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                String scope = artifact.getScope();
                return !"test".equals(scope) && !"provided".equals(scope);
            }
        }, MavenUtils.getErlangDependencies(project)));
    }

    public static Set<Artifact> getErlangArtifacts(MavenProject project) {
        return new HashSet<Artifact>(CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                String type = artifact.getType();
                return PackagingType.ERLANG_OTP.isA(type) || PackagingType.ERLANG_STD.isA(type);
            }
        }, MavenUtils.getArtifacts(project)));
    }

    public static Set<Artifact> getErlangDependencies(MavenProject project) {
        return new HashSet<Artifact>(CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                String type = artifact.getType();
                return PackagingType.ERLANG_OTP.isA(type) || PackagingType.ERLANG_STD.isA(type);
            }
        }, MavenUtils.getDependencies(project)));
    }

    public static Set<Artifact> getForeignDependenciesToPackage(MavenProject project) {
        return new HashSet<Artifact>(CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                String scope = artifact.getScope();
                return !"test".equals(scope) && !"provided".equals(scope);
            }
        }, MavenUtils.getForeignDependencies(project)));
    }

    public static Set<Artifact> getForeignDependencies(MavenProject project) {
        return new HashSet<Artifact>(CollectionUtils.filter(new Predicate<Artifact>(){

            @Override
            public boolean pred(Artifact artifact) {
                PackagingType type = PackagingType.fromString(artifact.getType());
                return type == PackagingType.UNSUPPORTED;
            }
        }, MavenUtils.getDependencies(project)));
    }

    public static Set<Artifact> getDependencies(MavenProject project) {
        Set artifacts = project.getDependencyArtifacts();
        return new HashSet<Artifact>(artifacts);
    }

    public static Set<Artifact> getArtifacts(MavenProject project) {
        Set artifacts = project.getArtifacts();
        return new HashSet<Artifact>(artifacts);
    }

    public static Map<String, String> getProjectReplacements(MavenProject project, String artifactQuote, String commonQuote) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("${ARTIFACT}", artifactQuote + project.getArtifactId() + artifactQuote);
        replacements.put("${DESCRIPTION}", commonQuote + project.getDescription() + commonQuote);
        replacements.put("${ID}", commonQuote + project.getId() + commonQuote);
        replacements.put("${NAME}", commonQuote + project.getName() + commonQuote);
        replacements.put("${VERSION}", commonQuote + project.getVersion() + commonQuote);
        return replacements;
    }

    public static void logContent(Log log, LogLevel level, File file, String linePrefix) {
        MavenUtils.logMultiLineString(log, level, file.getAbsolutePath() + ":", linePrefix);
        try {
            MavenUtils.logMultiLineString(log, level, FileUtils.fileRead((File)file), linePrefix);
        }
        catch (IOException e) {
            MavenUtils.logMultiLineString(log, level, e.getMessage(), linePrefix);
        }
    }

    public static void logMultiLineString(Log log, LogLevel level, String multiLineString) {
        MavenUtils.logMultiLineString(log, level, multiLineString, "");
    }

    public static void logMultiLineString(Log log, LogLevel level, String multiLineString, String linePrefix) {
        String[] lines;
        block6: for (String line : lines = multiLineString.split("\r?\n")) {
            switch (level) {
                case DEBUG: {
                    log.debug((CharSequence)(linePrefix + line));
                    continue block6;
                }
                case INFO: {
                    log.info((CharSequence)(linePrefix + line));
                    continue block6;
                }
                case WARN: {
                    log.warn((CharSequence)(linePrefix + line));
                    continue block6;
                }
                case ERROR: {
                    log.error((CharSequence)(linePrefix + line));
                }
            }
        }
    }

    public static <T> void logCollection(Log log, LogLevel level, Collection<T> collection, String linePrefix) {
        for (T entry : collection) {
            switch (level) {
                case DEBUG: {
                    log.debug((CharSequence)(linePrefix + entry.toString()));
                    break;
                }
                case INFO: {
                    log.info((CharSequence)(linePrefix + entry.toString()));
                    break;
                }
                case WARN: {
                    log.warn((CharSequence)(linePrefix + entry.toString()));
                    break;
                }
                case ERROR: {
                    log.error((CharSequence)(linePrefix + entry.toString()));
                }
            }
        }
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;


        public static LogLevel fromString(String level) {
            if ("debug".equals(level)) {
                return DEBUG;
            }
            if ("warn".equals(level)) {
                return WARN;
            }
            if ("error".equals(level)) {
                return ERROR;
            }
            return INFO;
        }
    }
}

