/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.util;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import eu.lindenbaum.maven.util.Predicate;
import java.util.ArrayList;
import java.util.Collection;

public final class CollectionUtils {
    public static <A, B> Collection<B> map(MapFunction<A, B> f, Collection<A> as) {
        ArrayList<B> bs = new ArrayList<B>();
        for (A a : as) {
            bs.add(f.apply(a));
        }
        return bs;
    }

    public static <B> Collection<B> map(MapFunction<OtpErlangObject, B> f, OtpErlangList as) {
        ArrayList<B> bs = new ArrayList<B>();
        for (OtpErlangObject a : as.elements()) {
            bs.add(f.apply(a));
        }
        return bs;
    }

    public static <A> Collection<A> filter(Predicate<A> p, Collection<A> as) {
        ArrayList<A> bs = new ArrayList<A>();
        for (A a : as) {
            if (!p.pred(a)) continue;
            bs.add(a);
        }
        return bs;
    }

    public static <A, B> B foldl(FoldFunction<A, B> f, B initial, Collection<A> as) {
        B acc = initial;
        for (A a : as) {
            acc = f.apply(a, acc);
        }
        return acc;
    }

    public static interface FoldFunction<A, B> {
        public B apply(A var1, B var2);
    }

    public static interface MapFunction<A, B> {
        public B apply(A var1);
    }
}

