/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.report;

import eu.lindenbaum.maven.ErlangReport;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.ProfilingResult;
import eu.lindenbaum.maven.util.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class ProfilingReport
extends ErlangReport {
    public String getDescription(Locale l) {
        return "Profiling results, as reported by erlang:profiling analysis.";
    }

    public String getName(Locale l) {
        return "profiling";
    }

    public String getOutputName() {
        return "erlang-profiling-report";
    }

    @Override
    protected void execute(Log log, Locale locale, Properties p) throws MojoExecutionException {
        File profilingReportDir = p.targetLayout().profilingReports();
        List<File> profilingReports = FileUtils.getFilesRecursive(profilingReportDir, ".txt");
        if (profilingReports.size() < 1) {
            log.info((CharSequence)"Nothing to do.");
            return;
        }
        ProfilingResult.Report report = new ProfilingResult.Report(profilingReports.get(0), p);
        File outdir = new File(this.getReportOutputDirectory(), "profiling");
        FileUtils.ensureDirectories(outdir);
        this.generate(report, log, locale);
        log.info((CharSequence)"Successfully generated profiling report.");
    }

    void generate(ProfilingResult.Report report, Log log, Locale locale) {
        log.debug((CharSequence)("Generating profling HTML report from " + report.getNumberOfRows() + " result lines."));
        this.generateReportHeader(this.getSink(), locale);
        this.generateReportTable(report, this.getSink(), locale);
        this.generateReportFooter(this.getSink(), locale);
    }

    void generateReportHeader(Sink sink, Locale locale) {
        String title = "Profiling Report";
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.getDescription(locale));
        sink.paragraph_();
        sink.section1_();
    }

    void generateReportTable(ProfilingResult.Report report, Sink sink, Locale locale) {
        sink.section2();
        sink.sectionTitle2();
        sink.text("Profiled functions");
        sink.sectionTitle2_();
        sink.section2_();
        sink.table();
        sink.tableRow();
        this.sinkTableHeader(sink, "Module:Function/Arity");
        this.sinkTableHeader(sink, "Calls");
        this.sinkTableHeader(sink, "Time");
        this.sinkTableHeader(sink, "\u00b5S/Call");
        sink.tableRow_();
        for (ProfilingResult.Report.Row row : report.getRows()) {
            sink.tableRow();
            this.sinkCell(sink, row.name);
            this.sinkCell(sink, row.calls);
            this.sinkCell(sink, row.time);
            this.sinkCell(sink, row.microSecondsPerCall);
            sink.tableRow_();
        }
        sink.table_();
    }

    void generateReportFooter(Sink sink, Locale locale) {
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkTableHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkCell(Sink sink, float microSecondsPerCall) {
        this.sinkCell(sink, Float.toString(microSecondsPerCall));
    }

    private void sinkCell(Sink sink, int calls) {
        this.sinkCell(sink, Integer.toString(calls));
    }
}

