/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.report;

import eu.lindenbaum.maven.ErlangReport;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.CoverageReportResult;
import eu.lindenbaum.maven.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class CoverageReport
extends ErlangReport {
    private static final String LINE_PATTERN = "<span {0}><a name=\"{3}-{1}\">{1,number,0000}</a>: {2}</span>\n";
    private static final String RED_LINE_ANNOTATION = "style=\"background: #faa;\"";
    private static final String GREEN_LINE_ANNOTATION = "style=\"background: #afa;\"";
    private static final String NO_LINE_ANNOTATION = "";

    public String getDescription(Locale locale) {
        return "Test coverage results, as reported by the Erlang coverage analysis tool.";
    }

    public String getName(Locale locale) {
        return "coverage";
    }

    public String getOutputName() {
        return "erlang-coverage-report";
    }

    @Override
    protected void execute(Log log, Locale locale, Properties p) throws MojoExecutionException {
        File coverageReportsDir = p.targetLayout().coverageReports();
        List<File> coverageReports = FileUtils.getFilesRecursive(coverageReportsDir, ".txt");
        if (coverageReports.size() < 1) {
            log.info((CharSequence)"Nothing to do.");
            return;
        }
        CoverageReportResult.Report report = new CoverageReportResult.Report(coverageReports.get(0));
        File outdir = new File(this.getReportOutputDirectory(), "coverage");
        FileUtils.ensureDirectories(outdir);
        this.generateReport(locale, report);
        log.info((CharSequence)"Successfully generated coverage report.");
    }

    private void generateReport(Locale locale, CoverageReportResult.Report report) {
        this.generateReportHeader(this.getSink(), locale, report);
        this.generateReportSummary(this.getSink(), locale, report);
        this.generateReportModulesSummary(this.getSink(), locale, report);
        this.generateReportForEachModule(this.getSink(), locale, report);
        this.generateReportFooter(this.getSink(), locale, report);
    }

    private void generateReportHeader(Sink sink, Locale locale, CoverageReportResult.Report report) {
        String title = "Test Coverage Report";
        sink.head();
        sink.title();
        sink.text(title);
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text(this.getDescription(locale));
        sink.paragraph_();
        sink.section1_();
    }

    private void generateReportSummary(Sink sink, Locale locale, CoverageReportResult.Report report) {
        sink.section2();
        sink.sectionTitle2();
        sink.text("Summary");
        sink.sectionTitle2_();
        sink.section2_();
        sink.rawText("<!-- " + this.summaryComment(report) + " -->");
        sink.table();
        sink.tableRow();
        this.sinkTableHeader(sink, NO_LINE_ANNOTATION);
        this.sinkTableHeader(sink, "Coverage");
        this.sinkTableHeader(sink, "Modules");
        this.sinkTableHeader(sink, "Functions");
        this.sinkTableHeader(sink, "Clauses");
        this.sinkTableHeader(sink, "Lines");
        this.sinkTableHeader(sink, "Covered lines");
        this.sinkTableHeader(sink, "Not covered lines");
        sink.tableRow_();
        sink.tableRow();
        this.sinkIsCoveredImageCell(sink, report.getCoverage() == 100);
        this.sinkCell(sink, report.getCoverage() + "%");
        this.sinkCell(sink, Integer.toString(report.getNumberOfModules()));
        this.sinkCell(sink, Integer.toString(report.getNumberOfFunctions()));
        this.sinkCell(sink, Integer.toString(report.getNumberOfClauses()));
        this.sinkCell(sink, Integer.toString(report.getNumberOfLines()));
        this.sinkCell(sink, Integer.toString(report.getNumberOfCoveredLines()));
        this.sinkCell(sink, Integer.toString(report.getNumberOfNotCoveredLines()));
        sink.tableRow_();
        sink.table_();
    }

    private String summaryComment(CoverageReportResult.Report report) {
        StringBuilder sb = new StringBuilder();
        sb.append("summary: ").append(report.getCoverage());
        sb.append(",").append(report.getNumberOfModules());
        sb.append(",").append(report.getNumberOfFunctions());
        sb.append(",").append(report.getNumberOfClauses());
        sb.append(",").append(report.getNumberOfLines());
        sb.append(",").append(report.getNumberOfCoveredLines());
        sb.append(",").append(report.getNumberOfNotCoveredLines());
        return sb.toString();
    }

    private void generateReportModulesSummary(Sink sink, Locale locale, CoverageReportResult.Report report) {
        sink.section2();
        sink.sectionTitle2();
        sink.text("Modules");
        sink.sectionTitle2_();
        sink.section2_();
        sink.table();
        sink.tableRow();
        this.sinkTableHeader(sink, NO_LINE_ANNOTATION);
        this.sinkTableHeader(sink, "Coverage");
        this.sinkTableHeader(sink, "Module");
        this.sinkTableHeader(sink, "Functions");
        this.sinkTableHeader(sink, "Clauses");
        this.sinkTableHeader(sink, "Lines");
        this.sinkTableHeader(sink, "Covered lines");
        this.sinkTableHeader(sink, "Not covered lines");
        sink.tableRow_();
        for (CoverageReportResult.Report.Module module : report.getModules()) {
            sink.tableRow();
            this.sinkIsCoveredImageCell(sink, module.getCoverage() == 100);
            this.sinkCell(sink, module.getCoverage() + "%");
            this.sinkModuleNameCell(sink, module);
            this.sinkCell(sink, Integer.toString(module.getNumberOfFunctions()));
            this.sinkCell(sink, Integer.toString(module.getNumberOfClauses()));
            this.sinkCell(sink, Integer.toString(module.getNumberOfLines()));
            this.sinkCell(sink, Integer.toString(module.getNumberOfCoveredLines()));
            this.sinkCell(sink, Integer.toString(module.getNumberOfNotCoveredLines()));
            sink.tableRow_();
        }
        sink.table_();
    }

    private void generateReportForEachModule(Sink sink, Locale locale, CoverageReportResult.Report report) {
        for (CoverageReportResult.Report.Module module : report.getModules()) {
            sink.section3();
            sink.sectionTitle3();
            sink.anchor(module.getName());
            sink.text(module.getName());
            sink.anchor_();
            sink.section3_();
            sink.table();
            sink.tableRow();
            this.sinkTableHeader(sink, NO_LINE_ANNOTATION);
            this.sinkTableHeader(sink, "Coverage");
            this.sinkTableHeader(sink, "Function");
            this.sinkTableHeader(sink, "Clauses");
            this.sinkTableHeader(sink, "Lines");
            this.sinkTableHeader(sink, "Covered lines");
            this.sinkTableHeader(sink, "Not covered lines");
            sink.tableRow_();
            for (CoverageReportResult.Report.Function function : module.getFunctions()) {
                sink.tableRow();
                this.sinkIsCoveredImageCell(sink, function.getCoverage() == 100);
                this.sinkCell(sink, function.getCoverage() + "%");
                this.sinkCell(sink, function.getName());
                this.sinkCell(sink, Integer.toString(function.getNumberOfClauses()));
                this.sinkCell(sink, Integer.toString(function.getNumberOfLines()));
                this.sinkCell(sink, Integer.toString(function.getNumberOfCoveredLines()));
                this.sinkCell(sink, Integer.toString(function.getNumberOfNotCoveredLines()));
                sink.tableRow_();
            }
            sink.table_();
            this.generateModuleLineCoverage(sink, locale, module);
        }
    }

    private void generateModuleLineCoverage(Sink sink, Locale locale, CoverageReportResult.Report.Module module) {
        try {
            String sourceCodeLine;
            File src = this.getProperties().sourceLayout().src();
            File moduleSourceFile = new File(src, module.getName() + ".erl");
            BufferedReader reader = new BufferedReader(new FileReader(moduleSourceFile));
            sink.verbatim(true);
            int lineNumber = 1;
            while ((sourceCodeLine = reader.readLine()) != null) {
                String lineStyle = this.lineStyle(module, lineNumber);
                String moduleName = module.getName();
                String cleanLine = sourceCodeLine.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                String formattedLine = MessageFormat.format(LINE_PATTERN, lineStyle, lineNumber, cleanLine, moduleName);
                sink.rawText(formattedLine);
                ++lineNumber;
            }
            sink.verbatim_();
            reader.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage());
        }
    }

    private String lineStyle(CoverageReportResult.Report.Module module, int lineNumber) {
        if (module.notExecutable(lineNumber)) {
            return NO_LINE_ANNOTATION;
        }
        if (module.isCovered(lineNumber)) {
            return GREEN_LINE_ANNOTATION;
        }
        return RED_LINE_ANNOTATION;
    }

    private void generateReportFooter(Sink sink, Locale locale, CoverageReportResult.Report report) {
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkTableHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkIsCoveredImageCell(Sink sink, boolean covered) {
        this.sinkImageCell(sink, covered ? "images/icon_success_sml.gif" : "images/icon_warning_sml.gif");
    }

    private void sinkImageCell(Sink sink, String string) {
        sink.tableCell();
        sink.figure();
        sink.figureGraphics(string);
        sink.figure_();
        sink.tableCell_();
    }

    private void sinkModuleNameCell(Sink sink, CoverageReportResult.Report.Module module) {
        sink.tableCell();
        sink.link("#" + module.getName());
        sink.text(module.getName());
        sink.link_();
        sink.tableCell_();
    }
}

