/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.rel;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.CheckRelResult;
import eu.lindenbaum.maven.erlang.CheckRelScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.RuntimeInfo;
import eu.lindenbaum.maven.erlang.RuntimeInfoScript;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class TestRunner
extends ErlangMojo {
    private boolean skipReleaseTest;
    private String otpRelease;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" T E S T - R U N N E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        RuntimeInfoScript infoScript = new RuntimeInfoScript();
        RuntimeInfo runtimeInfo = MavenSelf.get(p.cookie()).exec(p.node(), infoScript);
        if (!this.skipReleaseTest) {
            TestRunner.checkOtpReleaseVersion(log, this.otpRelease, runtimeInfo.getOtpRelease());
        } else {
            log.warn((CharSequence)"Warnings:");
            log.warn((CharSequence)" * Erlang/OTP release version check is skipped, standard Erlang/OTP");
            log.warn((CharSequence)("   applications will be included from release '" + runtimeInfo.getOtpRelease() + "'"));
        }
        String releaseName = p.project().getArtifactId();
        String releaseVersion = p.project().getVersion();
        Set<Artifact> artifacts = MavenUtils.getErlangReleaseArtifacts(p.project());
        File relFile = p.targetLayout().relFile();
        CheckRelScript relScript = new CheckRelScript(relFile);
        CheckRelResult relResult = MavenSelf.get(p.cookie()).exec(p.node(), relScript);
        if (!relResult.success()) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * failed to consult release file ");
            MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, relFile, "   ");
            throw new MojoFailureException("Failed to consult " + relFile + ".");
        }
        TestRunner.checkReleaseName(log, relFile, releaseName, relResult.getName());
        TestRunner.checkReleaseVersion(log, relFile, releaseVersion, relResult.getReleaseVersion());
        TestRunner.checkDependencies(log, artifacts, relResult.getApplications());
        log.info((CharSequence)"All tests passed.");
    }

    static void checkOtpReleaseVersion(Log log, String expected, String actual) throws MojoFailureException {
        boolean otpReleaseVersionMismatch = true;
        if (expected == null) {
            throw new MojoFailureException("Missing required Erlang/OTP release specification.");
        }
        if (expected.contains("|")) {
            String[] expects;
            for (String e : expects = expected.split("\\|")) {
                if (!TestRunner.versionsAreCompatible(e, actual)) continue;
                otpReleaseVersionMismatch = false;
            }
        } else {
            boolean bl = otpReleaseVersionMismatch = !TestRunner.versionsAreCompatible(expected, actual);
        }
        if (otpReleaseVersionMismatch) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)" * backend node does not run the required Erlang/OTP release, required");
            log.error((CharSequence)("   release is '" + expected + "' but backend node runs '" + actual + "'"));
            String msg = "Required Erlang/OTP release not available '" + expected + "' != '" + actual + "'.";
            throw new MojoFailureException(msg);
        }
    }

    private static boolean versionsAreCompatible(String expected, String actual) {
        if (expected.endsWith("*")) {
            return actual.toLowerCase().startsWith(expected.replaceAll("\\*", "").toLowerCase());
        }
        return actual.toLowerCase().equals(expected.toLowerCase());
    }

    private static void checkDependencies(Log log, Collection<Artifact> expected, Map<String, String> actual) throws MojoFailureException {
        boolean errors = false;
        ArrayList<String> errorLines = new ArrayList<String>();
        for (Artifact artifact : expected) {
            String expectedVersion = artifact.getBaseVersion();
            String actualVersion = actual.get(artifact.getArtifactId());
            if (actualVersion == null) {
                errorLines.add(" * dependency '" + artifact.getArtifactId() + "' is not included");
                errorLines.add("   in the .rel file");
                errors = true;
                continue;
            }
            if (actualVersion.equals(expectedVersion)) continue;
            errorLines.add(" * version mismatch for '" + artifact.getArtifactId() + "'");
            errorLines.add("   pom version is '" + expectedVersion + "' while .rel version");
            errorLines.add("   is '" + actualVersion + "'");
            errors = true;
        }
        if (actual.get("kernel") == null || actual.get("stdlib") == null) {
            errorLines.add(" * the mandatory applications 'kernel' and 'stdlib' must be part of");
            errorLines.add("   every release");
            errors = true;
        }
        if (errors) {
            log.error((CharSequence)"Errors:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, errorLines, "");
            throw new MojoFailureException("Checking dependencies failed, see previous output for detailed description.");
        }
    }

    private static void checkReleaseName(Log log, File relFile, String expected, String actual) throws MojoFailureException {
        if (!expected.equals(actual)) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)(" * release name mismatch, project release name is '" + expected + "'"));
            log.error((CharSequence)("   while .rel release name is '" + actual + "'"));
            MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, relFile, "   ");
            throw new MojoFailureException("Release name mismatch '" + expected + "' != '" + actual + "'.");
        }
    }

    private static void checkReleaseVersion(Log log, File relFile, String expected, String actual) throws MojoFailureException {
        if (!expected.equals(actual)) {
            log.error((CharSequence)"Errors:");
            log.error((CharSequence)(" * release version mismatch, project release version is '" + expected + "'"));
            log.error((CharSequence)("   while .rel release version is '" + actual + "'"));
            MavenUtils.logContent(log, MavenUtils.LogLevel.ERROR, relFile, "   ");
            throw new MojoFailureException("Release version mismatch '" + expected + "' != '" + actual + "'.");
        }
    }
}

