/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.rel;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.archiver.TarGzArchiver;
import eu.lindenbaum.maven.archiver.TarGzUnarchiver;
import eu.lindenbaum.maven.erlang.CreateRELEASESScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.RuntimeInfo;
import eu.lindenbaum.maven.erlang.RuntimeInfoScript;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import eu.lindenbaum.maven.util.MojoUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class TargetSystemPackager
extends ErlangMojo {
    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" T A R G E T - S Y S T E M - P A C K A G E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        PackagingType packagingType = p.packagingType();
        if (PackagingType.ERLANG_REL != packagingType) {
            throw new MojoExecutionException("Mojo does not support packaging type " + (Object)((Object)packagingType) + ".");
        }
        if (MojoUtils.isWindows()) {
            throw new MojoExecutionException("Mojo is not supported on Microsoft Windows systems.");
        }
        File target = p.targetLayout().base();
        File tmp = new File(target, "tmp");
        File tmpBin = new File(tmp, "bin");
        File tmpLog = new File(tmp, "log");
        FileUtils.ensureDirectories(tmp, tmpBin, tmpLog);
        File readme = new File(tmpLog, "README_NOT");
        String data = "README\n\nIf this directory does not exist 'start' will fail silently.\n";
        FileUtils.writeFile(readme, data);
        File releaseTarGz = p.targetLayout().projectArtifact();
        TarGzUnarchiver unarchiver = new TarGzUnarchiver(p.node(), p.cookie(), tmp);
        try {
            unarchiver.extract(releaseTarGz);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to extract " + releaseTarGz + ": " + e.getMessage());
        }
        RuntimeInfoScript infoScript = new RuntimeInfoScript();
        RuntimeInfo runtimeInfo = MavenSelf.get(p.cookie()).exec(p.node(), infoScript);
        File tmpLib = new File(tmp, "lib");
        File tmpReleases = new File(tmp, "releases");
        File tmpErts = new File(tmp, "erts-" + runtimeInfo.getVersion());
        File tmpErtsBin = new File(tmpErts, "bin");
        FileUtils.removeFiles(new File(tmpErtsBin, "erl"), new File(tmpErtsBin, "start"));
        File startErlData = new File(tmpReleases, "start_erl.data");
        String data2 = runtimeInfo.getVersion() + " " + p.project().getVersion();
        FileUtils.writeFile(startErlData, data2);
        FileUtils.removeFilesRecursive(tmpErtsBin, ".src");
        File start = new File(tmpBin, "start");
        FileUtils.extractFileFromClassPath(((Object)((Object)this)).getClass(), "", "start", start);
        File attach = new File(tmpBin, "attach");
        FileUtils.extractFileFromClassPath(((Object)((Object)this)).getClass(), "", "attach", attach);
        for (File file : tmpBin.listFiles()) {
            file.setExecutable(true, false);
        }
        String releaseFileName = p.targetLayout().relFile().getName();
        CreateRELEASESScript script = new CreateRELEASESScript(tmp, new File(tmpReleases, releaseFileName));
        String result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        if (!"ok".equals(result)) {
            throw new MojoExecutionException("Failed to create RELEASES file: " + result + ".");
        }
        String targetSystemSuffix = "-target-system.tar.gz";
        String targetName = releaseTarGz.getName().replace(".tar.gz", targetSystemSuffix);
        File targetSystemTarGz = new File(target, targetName);
        try {
            TarGzArchiver archiver = new TarGzArchiver(p.node(), p.cookie(), targetSystemTarGz);
            archiver.addFile(tmpBin);
            archiver.addFile(tmpLog);
            archiver.addFile(tmpErts);
            archiver.addFile(tmpLib);
            archiver.addFile(tmpReleases);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create " + targetSystemTarGz + ": " + e.getMessage());
        }
        FileUtils.removeDirectory(tmp);
        log.info((CharSequence)"Successfully created target system package:");
        log.info((CharSequence)targetSystemTarGz.toString());
    }
}

