/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.rel;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.archiver.TarGzUnarchiver;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.erlang.MakeRelupScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class RelupGenerator
extends ErlangMojo {
    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" R E L U P - G E N E R A T O R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        PackagingType packagingType = p.packagingType();
        if (packagingType != PackagingType.ERLANG_REL) {
            throw new MojoExecutionException("Mojo does not support packaging type " + (Object)((Object)packagingType) + ".");
        }
        ArrayList<String> releases = new ArrayList<String>();
        ArrayList<File> paths = new ArrayList<File>();
        paths.add(new File(new File(p.targetLayout().lib(), "*"), "ebin"));
        Artifact artifact = p.project().getArtifact();
        Set<ArtifactVersion> availableVersions = MavenUtils.getAvailableVersions(artifact, p.components());
        VersionRange range = MavenUtils.createVersionRange("(, " + artifact.getVersion() + ")");
        for (ArtifactVersion artifactVersion : availableVersions) {
            Artifact toResolve;
            if (!range.containsVersion(artifactVersion) || (toResolve = MavenUtils.getArtifact(artifact, artifactVersion.toString(), p.components())).isSnapshot()) continue;
            String releaseName = RelupGenerator.getReleaseName(toResolve);
            File destination = new File(p.targetLayout().base(), releaseName);
            TarGzUnarchiver unarchiver = new TarGzUnarchiver(p.node(), p.cookie(), destination);
            RelupGenerator.extract(unarchiver, MavenUtils.getArtifactFile(toResolve, p.components()));
            File relFile = new File(new File(destination, "releases"), releaseName + ".rel");
            FileUtils.copyFiles(p.targetLayout().base(), relFile);
            paths.add(new File(new File(new File(destination, "lib"), "*"), "ebin"));
            releases.add(releaseName);
        }
        File relFile = p.targetLayout().relFile();
        File relupFile = p.targetLayout().relupFile();
        MakeRelupScript script = new MakeRelupScript(relupFile, relFile, releases, paths);
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        if (!result.success()) {
            result.logOutput(log);
            throw new MojoExecutionException("Failed to create release upgrade file.");
        }
        log.info((CharSequence)"Successfully generated release upgrade file.");
        MavenUtils.logContent(log, MavenUtils.LogLevel.INFO, relupFile, "");
    }

    private static void extract(TarGzUnarchiver unarchiver, File file) throws MojoExecutionException {
        try {
            unarchiver.extract(file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to extract " + file + ".", (Exception)e);
        }
    }

    private static String getReleaseName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getBaseVersion();
    }
}

