/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.UploadScript;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class TestUploader
extends ErlangMojo {
    private String remote;
    private boolean withDependencies;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" T E S T S - U P L O A D E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (p.node().equals(this.remote)) {
            log.error((CharSequence)"Target node and backend node must not be the same node.");
            throw new MojoExecutionException("Target node equals backend node.");
        }
        PackagingType packagingType = p.packagingType();
        if (packagingType == PackagingType.ERLANG_REL) {
            throw new MojoExecutionException("Mojo does not support packaging type " + (Object)((Object)packagingType) + ".");
        }
        String target = "'" + this.remote + "'";
        List<File> modules = p.modules(true, this.withDependencies);
        List<File> resources = p.resources(true, this.withDependencies);
        UploadScript script = new UploadScript(target, modules, new ArrayList<File>(), resources);
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        result.logOutput(log);
        if (!result.success()) {
            throw new MojoExecutionException("Uploading tests failed.");
        }
    }
}

