/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.BeamCompilerScript;
import eu.lindenbaum.maven.erlang.CompilerResult;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public final class TestCompiler
extends ErlangMojo {
    private boolean skipTests;
    private String testCompilerOptions;
    private String[] testCompileFirst;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException, MojoFailureException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" T E S T - C O M P I L E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (this.skipTests) {
            log.info((CharSequence)"Test compilation is skipped.");
            return;
        }
        File out = p.targetLayout().testEbin();
        FileUtils.ensureDirectories(out);
        ArrayList<File> files = new ArrayList<File>();
        for (File d : p.sourceLayout().testSrcs()) {
            files.addAll(FileUtils.getFilesRecursive(d, ".erl"));
        }
        ArrayList<File> firstFiles = new ArrayList<File>();
        if (this.testCompileFirst != null) {
            for (String compileFirstFile : this.testCompileFirst) {
                File file = FileUtils.getFile(compileFirstFile, files);
                firstFiles.add(file);
                files.remove(file);
            }
        }
        if (!files.isEmpty() || !firstFiles.isEmpty()) {
            List<File> testSupportFiles = p.testSupportScripts();
            TestCompiler.extractTestSupportFiles(((Object)((Object)this)).getClass(), testSupportFiles);
            files.addAll(testSupportFiles);
            ArrayList<String> options = new ArrayList<String>();
            options.add("debug_info");
            options.add("export_all");
            options.add("{d, 'TEST'}");
            if (this.testCompilerOptions != null && !this.testCompilerOptions.isEmpty()) {
                log.info((CharSequence)("Using additinal test compiler options: " + this.testCompilerOptions));
                options.add(this.testCompilerOptions);
            }
            List<File> includes = p.includePaths(true);
            BeamCompilerScript script = new BeamCompilerScript(files, firstFiles, out, includes, options);
            CompilerResult result = MavenSelf.get(p.cookie()).exec(p.testNode(), script);
            List<File> compiled = result.getCompiled();
            List<File> failed = result.getFailed();
            List<String> errors = result.getErrors();
            List<String> warnings = result.getWarnings();
            if (compiled.size() > 0) {
                log.debug((CharSequence)"Compiled:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, compiled, " * ");
            }
            if (errors.size() > 0) {
                log.error((CharSequence)"Errors:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, errors, "");
            }
            if (warnings.size() > 0) {
                log.warn((CharSequence)"Warnings:");
                MavenUtils.logCollection(log, MavenUtils.LogLevel.WARN, warnings, "");
            }
            if (failed.size() > 0) {
                throw new MojoFailureException("Failed to compile " + failed + ".");
            }
            log.info((CharSequence)"Successfully compiled the project test sources.");
        } else {
            log.info((CharSequence)"No test source files to compile.");
        }
    }

    private static void extractTestSupportFiles(Class<?> caller, Collection<File> testSupportFiles) throws MojoExecutionException {
        String path = "/" + caller.getPackage().getName().replace(".", "/");
        for (File file : testSupportFiles) {
            FileUtils.extractFileFromClassPath(caller, path, file.getName(), file);
        }
    }
}

