/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class ResourceGenerator
extends ErlangMojo {
    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        ResourceGenerator.copySources(log, p);
        ResourceGenerator.copyIncludes(log, p);
        ResourceGenerator.copyResources(log, p);
        ResourceGenerator.copyNonErlangDependencies(log, p);
        ResourceGenerator.copyDocumentationResources(log, p);
    }

    private static void copySources(Log log, Properties p) throws MojoExecutionException {
        File src = p.sourceLayout().src();
        File targetSrc = p.targetLayout().src();
        FileUtils.removeDirectory(targetSrc);
        Collection<File> current = FileUtils.copyDirectory(src, targetSrc, FileUtils.SOURCE_FILTER);
        if (current.size() > 0) {
            log.debug((CharSequence)"Copied sources:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, current, " * ");
        } else {
            FileUtils.removeEmptyDirectory(targetSrc);
        }
    }

    private static void copyIncludes(Log log, Properties p) throws MojoExecutionException {
        File include = p.sourceLayout().include();
        File targetInclude = p.targetLayout().include();
        FileUtils.removeDirectory(targetInclude);
        Collection<File> current = FileUtils.copyDirectory(include, targetInclude, FileUtils.SOURCE_FILTER);
        if (current.size() > 0) {
            log.debug((CharSequence)"Copied includes:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, current, " * ");
        } else {
            FileUtils.removeEmptyDirectory(targetInclude);
        }
    }

    private static void copyResources(Log log, Properties p) throws MojoExecutionException {
        File priv = p.sourceLayout().priv();
        File targetPriv = p.targetLayout().priv();
        FileUtils.removeDirectory(targetPriv);
        Collection<File> current = FileUtils.copyDirectory(priv, targetPriv, FileUtils.NULL_FILTER);
        if (current.size() > 0) {
            log.debug((CharSequence)"Copied resources:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, current, " * ");
        } else {
            FileUtils.removeEmptyDirectory(targetPriv);
        }
    }

    private static void copyNonErlangDependencies(Log log, Properties p) {
        File targetPriv = p.targetLayout().priv();
        ArrayList<File> current = new ArrayList<File>();
        for (Artifact artifact : MavenUtils.getForeignDependenciesToPackage(p.project())) {
            File source = artifact.getFile();
            File destination = new File(targetPriv, source.getName());
            try {
                org.codehaus.plexus.util.FileUtils.copyFile((File)source, (File)destination);
                current.add(source);
            }
            catch (IOException e) {
                log.error((CharSequence)("Failed to copy artifact " + source.getPath() + " to " + targetPriv + "."), (Throwable)e);
            }
        }
        if (current.size() > 0) {
            log.debug((CharSequence)"Copied foreign artifacts:");
            MavenUtils.logCollection(log, MavenUtils.LogLevel.DEBUG, current, " * ");
        }
    }

    private static void copyDocumentationResources(Log log, Properties p) throws MojoExecutionException {
        Map<String, String> replacements = MavenUtils.getProjectReplacements(p.project(), "", "");
        File overviewEdoc = p.sourceLayout().overviewEdoc();
        if (overviewEdoc.isFile()) {
            File targetOverviewEdoc = p.targetLayout().overviewEdoc();
            FileUtils.copyFile(overviewEdoc, targetOverviewEdoc, replacements);
            log.debug((CharSequence)"Copied documentation resources:");
            log.debug((CharSequence)(" * " + overviewEdoc));
        }
    }
}

