/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo.app;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.TargetLayout;
import eu.lindenbaum.maven.archiver.TarGzUnarchiver;
import eu.lindenbaum.maven.erlang.CheckAppResult;
import eu.lindenbaum.maven.erlang.CheckAppScript;
import eu.lindenbaum.maven.erlang.GetAppupDirectiveScript;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.FileUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class AppupGenerator
extends ErlangMojo {
    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" A P P U P - G E N E R A T O R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        PackagingType packagingType = p.packagingType();
        if (packagingType == PackagingType.ERLANG_REL) {
            throw new MojoExecutionException("Mojo does not support packaging type " + (Object)((Object)packagingType) + ".");
        }
        TargetLayout targetLayout = p.targetLayout();
        Artifact artifact = p.project().getArtifact();
        File projectAppFile = targetLayout.appFile();
        TarGzUnarchiver unarchiver = new TarGzUnarchiver(p.node(), p.cookie(), targetLayout.base());
        Set<ArtifactVersion> availableVersions = MavenUtils.getAvailableVersions(artifact, p.components());
        HashMap<String, List<String>> upFromDirectivesMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> downToDirectivesMap = new HashMap<String, List<String>>();
        VersionRange range = MavenUtils.createVersionRange("(, " + artifact.getVersion() + ")");
        for (ArtifactVersion artifactVersion : availableVersions) {
            Artifact toResolve;
            if (!range.containsVersion(artifactVersion) || (toResolve = MavenUtils.getArtifact(artifact, artifactVersion.toString(), p.components())).isSnapshot()) continue;
            AppupGenerator.extract(unarchiver, MavenUtils.getArtifactFile(toResolve, p.components()));
            String toResolveVersion = toResolve.getBaseVersion();
            String toResolveBase = toResolve.getArtifactId() + "-" + toResolveVersion;
            File toResolveEbin = new File(new File(targetLayout.base(), toResolveBase), "ebin");
            File toResolveAppFile = new File(toResolveEbin, artifact.getArtifactId() + ".app");
            upFromDirectivesMap.put(toResolveVersion, this.getDirectives(p, toResolveAppFile, projectAppFile));
            downToDirectivesMap.put(toResolveVersion, this.getDirectives(p, projectAppFile, toResolveAppFile));
        }
        String upFrom = AppupGenerator.directivesToString(upFromDirectivesMap);
        String downTo = AppupGenerator.directivesToString(downToDirectivesMap);
        File appupTemplate = new File(targetLayout.base(), artifact.getArtifactId() + ".appup");
        FileUtils.writeFile(appupTemplate, "{${VERSION},\n " + upFrom + ",\n " + downTo + "}.");
        if (!appupTemplate.isFile()) {
            throw new MojoExecutionException("Failed to create application upgrade file.");
        }
        log.info((CharSequence)"Successfully generated application upgrade template.");
        MavenUtils.logContent(log, MavenUtils.LogLevel.INFO, appupTemplate, "");
    }

    private List<String> getDirectives(Properties p, File baseAppFile, File targetAppFile) throws MojoExecutionException {
        CheckAppScript baseScript = new CheckAppScript(baseAppFile);
        CheckAppResult baseAppResult = MavenSelf.get(p.cookie()).exec(p.node(), baseScript);
        List<String> baseModules = baseAppResult.getModules();
        CheckAppScript targetScript = new CheckAppScript(targetAppFile);
        CheckAppResult targetAppResult = MavenSelf.get(p.cookie()).exec(p.node(), targetScript);
        List<String> targetModules = targetAppResult.getModules();
        ArrayList<String> directives = new ArrayList<String>();
        ArrayList<String> addedModules = new ArrayList<String>(targetModules);
        addedModules.removeAll(baseModules);
        for (String addedModule : addedModules) {
            directives.add("{load_module,'" + addedModule + "'}");
        }
        ArrayList<String> updatedModules = new ArrayList<String>(targetModules);
        updatedModules.retainAll(baseModules);
        for (String updatedModule : updatedModules) {
            GetAppupDirectiveScript appupScript = new GetAppupDirectiveScript(updatedModule, baseAppFile.getParentFile());
            String directive = MavenSelf.get(p.cookie()).exec(p.node(), appupScript);
            if (directive == null) {
                throw new MojoExecutionException("Failed to generate directive for module " + updatedModule + ".");
            }
            directives.add(directive);
        }
        ArrayList<String> deletedModules = new ArrayList<String>(baseModules);
        deletedModules.removeAll(targetModules);
        for (String deletedModule : deletedModules) {
            directives.add("{delete_module,'" + deletedModule + "'}");
        }
        return directives;
    }

    private static String directivesToString(Map<String, List<String>> directives) {
        int i = 0;
        StringBuilder output = new StringBuilder("[");
        for (Map.Entry<String, List<String>> version : directives.entrySet()) {
            if (i++ != 0) {
                output.append(",\n  ");
            }
            String directiveString = ErlUtils.toList((Collection)version.getValue(), null, "", "");
            output.append("{\"" + version.getKey() + "\", " + directiveString + "}");
        }
        output.append("]");
        return output.toString();
    }

    private static void extract(TarGzUnarchiver unarchiver, File file) throws MojoExecutionException {
        try {
            unarchiver.extract(file);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to extract " + file + ".", (Exception)e);
        }
    }
}

