/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.SourceLayout;
import eu.lindenbaum.maven.util.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class Setup
extends ErlangMojo {
    private boolean withExtras;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        PackagingType packagingType = p.packagingType();
        if (packagingType == PackagingType.ERLANG_OTP || packagingType == PackagingType.ERLANG_STD) {
            this.setupAppDefaults(p);
        } else {
            this.setupRelDefaults(p);
        }
        log.info((CharSequence)"-->");
        if (this.withExtras) {
            this.setupExtras(p);
            log.info((CharSequence)"--> Checking dependencies...");
            this.checkIfProjectHasDependentArtifact(p, "maven-changes-plugin");
        }
        log.info((CharSequence)"--> Done!");
    }

    private void setupExtras(Properties p) throws MojoExecutionException {
        HashMap<String, File> folders = new HashMap<String, File>();
        File site = new File(p.sourceLayout().base(), "src/site");
        File changes = new File(p.sourceLayout().base(), "src/changes");
        File apt = new File(site, "apt");
        folders.put("site folder", site);
        folders.put("changes folder", changes);
        folders.put("apt folder", apt);
        for (Map.Entry folder : folders.entrySet()) {
            if (this.noFolder((File)folder.getValue(), (String)folder.getKey())) {
                this.createFolder((File)folder.getValue(), (String)folder.getKey());
                continue;
            }
            this.logSkipping();
        }
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("default-site.xml", new File(site, "site.xml"));
        files.put("default-changes.xml", new File(changes, "changes.xml"));
        for (Map.Entry entry : files.entrySet()) {
            if (this.noFile((File)entry.getValue())) {
                this.createFile((File)entry.getValue(), (String)entry.getKey());
                continue;
            }
            this.logSkipping();
        }
        File defaultApt = new File(apt, "index.apt.vm");
        if (this.noFile(new File(apt, "index.apt")) && this.noFile(defaultApt)) {
            this.createFile(defaultApt, "default-index.apt.vm");
        } else {
            this.logSkipping();
        }
    }

    private void setupAppDefaults(Properties p) throws MojoExecutionException {
        SourceLayout sourceLayout = p.sourceLayout();
        HashMap<String, File> folders = new HashMap<String, File>();
        folders.put("ebin folder", sourceLayout.ebin());
        folders.put("src folder", sourceLayout.src());
        folders.put("include folder", sourceLayout.include());
        folders.put("priv folder", sourceLayout.priv());
        for (File file : sourceLayout.testSrcs()) {
            folders.put("test src folder", file);
        }
        folders.put("test include folder", sourceLayout.testInclude());
        folders.put("test priv folder", sourceLayout.testPriv());
        for (Map.Entry entry : folders.entrySet()) {
            if (this.noFolder((File)entry.getValue(), (String)entry.getKey())) {
                this.createFolder((File)entry.getValue(), (String)entry.getKey());
                continue;
            }
            this.logSkipping();
        }
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("default.app", sourceLayout.appFile());
        files.put("default.appup", sourceLayout.appupFile());
        for (Map.Entry entry : files.entrySet()) {
            if (this.noFile((File)entry.getValue())) {
                this.createFile((File)entry.getValue(), (String)entry.getKey());
                continue;
            }
            this.logSkipping();
        }
    }

    private void setupRelDefaults(Properties p) throws MojoExecutionException {
        SourceLayout sourceLayout = p.sourceLayout();
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("default.rel", sourceLayout.relFile());
        files.put("default-sys.config", sourceLayout.sysConfigFile());
        files.put("default.relup", sourceLayout.relupFile());
        for (Map.Entry entry : files.entrySet()) {
            if (this.noFile((File)entry.getValue())) {
                this.createFile((File)entry.getValue(), (String)entry.getKey());
                continue;
            }
            this.logSkipping();
        }
    }

    private void checkIfProjectHasDependentArtifact(Properties p, String artifactId) {
        Artifact resolved = this.findProjectDependencyArtifact(p, artifactId);
        if (resolved == null) {
            this.getLog().info((CharSequence)("--> MISSING REQUIRED ARTIFACT: [" + artifactId + "]"));
        }
    }

    private Artifact findProjectDependencyArtifact(Properties p, String artifactId) {
        Set dependencies;
        Set plugins = p.project().getPluginArtifacts();
        if (plugins != null) {
            for (Artifact artifact : plugins) {
                if (!artifact.getArtifactId().equals(artifactId)) continue;
                return artifact;
            }
        }
        if ((dependencies = p.project().getDependencyArtifacts()) != null) {
            for (Artifact artifact : dependencies) {
                if (!artifact.getArtifactId().equals(artifactId)) continue;
                return artifact;
            }
        }
        return null;
    }

    private boolean noFolder(File folder, String name) {
        boolean exists = folder.isDirectory();
        this.logCheckingIf(name, exists);
        return !exists;
    }

    private void createFolder(File folder, String name) throws MojoExecutionException {
        this.logGeneratingDefault(name);
        FileUtils.ensureDirectories(folder);
    }

    private boolean noFile(File file) {
        boolean exists = file.isFile();
        this.logCheckingIf(file.getName(), exists);
        return !exists;
    }

    private void createFile(File file, String defaultFileName) throws MojoExecutionException {
        this.logGeneratingDefault(file.getName());
        FileUtils.extractFileFromClassPath(((Object)((Object)this)).getClass(), "", defaultFileName, file);
    }

    private void logCheckingIf(String string, boolean exists) {
        this.getLog().info((CharSequence)("--> Checking if " + string + " exists... [" + (exists ? "YES" : "NO") + "]"));
    }

    private void logSkipping() {
        this.getLog().info((CharSequence)"--> Skipping generation.");
    }

    private void logGeneratingDefault(String string) {
        this.getLog().info((CharSequence)("--> Generating default " + string + "."));
    }
}

