/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo;

import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.PackagingType;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.UploadReleaseScript;
import eu.lindenbaum.maven.erlang.UploadScript;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class ProjectUploader
extends ErlangMojo {
    private String remote;
    private boolean withDependencies;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" U P L O A D E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        if (p.node().equals(this.remote)) {
            log.error((CharSequence)"Target node and backend node must not be the same node.");
            throw new MojoExecutionException("Target node equals backend node.");
        }
        PackagingType packagingType = p.packagingType();
        if (PackagingType.ERLANG_OTP == packagingType || PackagingType.ERLANG_STD == packagingType) {
            ProjectUploader.uploadApplication(log, p, "'" + this.remote + "'", this.withDependencies);
        } else {
            ProjectUploader.uploadRelease(log, p, "'" + this.remote + "'");
        }
    }

    private static void uploadApplication(Log log, Properties p, String target, boolean withDependencies) throws MojoExecutionException {
        List<File> modules = p.modules(false, withDependencies);
        List<File> applicationFiles = p.applicationFiles(withDependencies);
        List<File> resourceFiles = p.resources(false, withDependencies);
        UploadScript script = new UploadScript(target, modules, applicationFiles, resourceFiles);
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        result.logOutput(log);
        if (!result.success()) {
            throw new MojoExecutionException("Uploading application failed.");
        }
    }

    private static void uploadRelease(Log log, Properties p, String target) throws MojoExecutionException {
        File artifact = p.targetLayout().projectArtifact();
        if (!artifact.isFile()) {
            throw new MojoExecutionException("Could not find packaged release " + artifact.getPath());
        }
        UploadReleaseScript script = new UploadReleaseScript(target, artifact);
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        if (!result.success()) {
            log.error((CharSequence)("Uploading release to " + target + " failed."));
            result.logOutput(log);
            throw new MojoExecutionException("Uploading release failed.");
        }
        log.info((CharSequence)("Successfully uploaded release to " + target + "."));
    }
}

