/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.mojo;

import com.ericsson.otp.erlang.OtpPeer;
import eu.lindenbaum.maven.ErlangMojo;
import eu.lindenbaum.maven.Properties;
import eu.lindenbaum.maven.erlang.CheckRelResult;
import eu.lindenbaum.maven.erlang.CheckRelScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.RunProjectScript;
import eu.lindenbaum.maven.erlang.UploadScript;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class ProjectRunner
extends ErlangMojo {
    private String remote;
    private boolean withDependencies;

    @Override
    protected void execute(Log log, Properties p) throws MojoExecutionException {
        log.info((CharSequence)MavenUtils.SEPARATOR);
        log.info((CharSequence)" R U N N E R");
        log.info((CharSequence)MavenUtils.SEPARATOR);
        boolean runOnRemoteNode = this.remote != null;
        String target = runOnRemoteNode ? "'" + this.remote + "'" : "node()";
        String targetPeer = new OtpPeer(runOnRemoteNode ? target : p.node()).toString();
        if (runOnRemoteNode) {
            ProjectRunner.upload(log, p, target, targetPeer, this.withDependencies);
        }
        ProjectRunner.start(log, p, target, targetPeer);
        if (!runOnRemoteNode) {
            log.info((CharSequence)"Press [ENTER] to complete the build and shutdown the backend node.");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private static void start(Log log, Properties p, String target, String targetPeer) throws MojoExecutionException {
        RunProjectScript script;
        switch (p.packagingType()) {
            case ERLANG_OTP: 
            case ERLANG_STD: {
                ArrayList<String> applications = new ArrayList<String>();
                applications.add(p.project().getArtifactId());
                applications.addAll(MavenUtils.getArtifactIds(MavenUtils.getErlangReleaseArtifacts(p.project())));
                Collections.reverse(applications);
                script = new RunProjectScript(target, applications);
                break;
            }
            default: {
                CheckRelScript checkScript = new CheckRelScript(p.targetLayout().relFile());
                CheckRelResult relResult = MavenSelf.get(p.cookie()).exec(p.node(), checkScript);
                ArrayList<String> applications = new ArrayList<String>();
                applications.addAll(relResult.getApplications().keySet());
                script = new RunProjectScript(target, applications, p.targetLayout().sysConfigFile());
                break;
            }
        }
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        result.logOutput(log);
        if (!result.success()) {
            throw new MojoExecutionException("Failed to run project on " + targetPeer + ".");
        }
        String cookie = p.cookie() != null ? " -setcookie " + p.cookie() + " " : "";
        log.info((CharSequence)("Successfully running project on " + targetPeer + "."));
        log.info((CharSequence)("For a remote shell use 'erl" + cookie + " -remsh " + targetPeer + " -name mynode@myhost'"));
    }

    private static void upload(Log log, Properties p, String target, String targetPeer, boolean withDependencies) throws MojoExecutionException {
        List<File> modules = p.modules(false, withDependencies);
        List<File> applicationFiles = p.applicationFiles(withDependencies);
        List<File> resourceFiles = p.resources(false, withDependencies);
        UploadScript script = new UploadScript(target, modules, applicationFiles, resourceFiles);
        GenericScriptResult result = MavenSelf.get(p.cookie()).exec(p.node(), script);
        result.logOutput(log);
        if (!result.success()) {
            throw new MojoExecutionException("Failed to upload applications to " + targetPeer + ".");
        }
    }
}

