/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangObject;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class UploadReleaseScript
extends AbstractScript<GenericScriptResult> {
    private final String remoteNode;
    private final File releasePackage;

    public UploadReleaseScript(String remoteNode, File releasePackage) throws MojoExecutionException {
        this.remoteNode = remoteNode;
        this.releasePackage = releasePackage;
    }

    @Override
    public String get() {
        return String.format(this.script, this.remoteNode, this.releasePackage.getAbsolutePath());
    }

    @Override
    public GenericScriptResult handle(final OtpErlangObject result) {
        return new GenericScriptResult(){

            @Override
            public boolean success() {
                return "ok".equals(ErlUtils.toString(result));
            }

            @Override
            public void logOutput(Log log) {
                if (!this.success()) {
                    MavenUtils.LogLevel level = MavenUtils.LogLevel.ERROR;
                    String multiLineString = ErlUtils.toString(result);
                    MavenUtils.logMultiLineString(log, level, multiLineString);
                }
            }
        };
    }
}

