/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class RunProjectScript
extends AbstractScript<GenericScriptResult> {
    private final String node;
    private final List<String> applications;
    private final File sysConfigFile;

    public RunProjectScript(String node, List<String> applications) throws MojoExecutionException {
        this(node, applications, new File("."));
    }

    public RunProjectScript(String node, List<String> applications, File sysConfigFile) throws MojoExecutionException {
        this.node = node;
        this.applications = applications;
        this.sysConfigFile = sysConfigFile;
    }

    @Override
    public String get() {
        String applications = ErlUtils.toList(this.applications, null, "'", "'");
        String configFile = this.sysConfigFile.getAbsolutePath();
        return String.format(this.script, this.node, applications, configFile);
    }

    @Override
    public GenericScriptResult handle(OtpErlangObject result) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)result;
        OtpErlangList succeeded = (OtpErlangList)resultTuple.elementAt(0);
        OtpErlangList failed = (OtpErlangList)resultTuple.elementAt(1);
        final ArrayList<String> succeededApplications = new ArrayList<String>();
        Iterator succeededIterator = succeeded.iterator();
        while (succeededIterator.hasNext()) {
            succeededApplications.add(ErlUtils.toString((OtpErlangObject)succeededIterator.next()));
        }
        final ArrayList<String> failedApplications = new ArrayList<String>();
        Iterator failedIterator = failed.iterator();
        while (failedIterator.hasNext()) {
            failedApplications.add(ErlUtils.toString((OtpErlangObject)failedIterator.next()));
        }
        return new GenericScriptResult(){

            @Override
            public boolean success() {
                return failedApplications.isEmpty();
            }

            @Override
            public void logOutput(Log log) {
                if (!succeededApplications.isEmpty()) {
                    log.info((CharSequence)"Applications successfully started:");
                    MavenUtils.logCollection(log, MavenUtils.LogLevel.INFO, succeededApplications, " * ");
                    log.info((CharSequence)"");
                }
                if (!failedApplications.isEmpty()) {
                    log.error((CharSequence)"Applications that could not be started:");
                    MavenUtils.logCollection(log, MavenUtils.LogLevel.ERROR, failedApplications, " * ");
                }
            }
        };
    }
}

