/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpConnection;
import com.ericsson.otp.erlang.OtpErlangList;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public final class NodeShutdownHook
extends Thread {
    private static final Map<String, NodeShutdownHook> instances = new HashMap<String, NodeShutdownHook>();
    private final String nodeName;
    private volatile String nodeCookie;

    private NodeShutdownHook(String nodeName, String nodeCookie) {
        this.nodeName = nodeName;
        this.nodeCookie = nodeCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeShutdownHook get(String nodeName, String nodeCookie) {
        Map<String, NodeShutdownHook> map = instances;
        synchronized (map) {
            NodeShutdownHook shutdownHook = instances.get(nodeName);
            if (shutdownHook == null) {
                shutdownHook = new NodeShutdownHook(nodeName, nodeCookie);
                instances.put(nodeName, shutdownHook);
            } else {
                shutdownHook.nodeCookie = nodeCookie;
            }
            return shutdownHook;
        }
    }

    @Override
    public void run() {
        try {
            OtpConnection connection = MavenSelf.get(this.nodeCookie).connect(this.nodeName);
            connection.sendRPC("erlang", "halt", new OtpErlangList());
            System.out.println("[INFO] Successfully shut down '" + this.nodeName + "'");
        }
        catch (IOException e) {
            System.out.println("[ERROR] Failed to shutdown '" + this.nodeName + "'");
        }
        catch (MojoExecutionException e) {
            System.out.println("[ERROR] Failed to shutdown '" + this.nodeName + "'");
        }
        System.out.println("[INFO] " + MavenUtils.SEPARATOR);
    }
}

