/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.CompilerResult;
import eu.lindenbaum.maven.util.ErlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public final class MibCompilerScript
extends AbstractScript<CompilerResult> {
    private final List<File> files;
    private final File outdir;
    private final List<File> includes;

    public MibCompilerScript(List<File> files, File outdir, List<File> includes) throws MojoExecutionException {
        this.files = files;
        this.outdir = outdir;
        this.includes = includes;
    }

    @Override
    public String get() {
        String out = this.outdir.getAbsolutePath();
        String incs = ErlUtils.toFilenameList(this.includes, "\"", "\"");
        String files = ErlUtils.toFilenameList(this.files, "\"", "\"");
        return String.format(this.script, out, incs, files);
    }

    @Override
    public CompilerResult handle(OtpErlangObject result) {
        OtpErlangTuple r = (OtpErlangTuple)result;
        OtpErlangList f = (OtpErlangList)r.elementAt(0);
        final ArrayList<File> failed = new ArrayList<File>();
        Iterator failedIterator = f.iterator();
        while (failedIterator.hasNext()) {
            failed.add(new File(ErlUtils.toString((OtpErlangObject)failedIterator.next(), false)));
        }
        OtpErlangList c = (OtpErlangList)r.elementAt(1);
        final ArrayList<File> compiled = new ArrayList<File>();
        Iterator compiledIterator = c.iterator();
        while (compiledIterator.hasNext()) {
            compiled.add(new File(ErlUtils.toString((OtpErlangObject)compiledIterator.next(), false)));
        }
        Collections.reverse(compiled);
        OtpErlangList e = (OtpErlangList)r.elementAt(2);
        final ArrayList<String> errors = new ArrayList<String>();
        Iterator errorIterator = e.iterator();
        while (errorIterator.hasNext()) {
            errors.add(ErlUtils.toString((OtpErlangObject)errorIterator.next(), false));
        }
        return new CompilerResult(){

            @Override
            public List<File> getFailed() {
                return failed;
            }

            @Override
            public List<File> getCompiled() {
                return compiled;
            }

            @Override
            public List<String> getErrors() {
                return errors;
            }

            @Override
            public List<String> getWarnings() {
                return Collections.emptyList();
            }
        };
    }
}

