/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class MakeScriptScript
extends AbstractScript<GenericScriptResult> {
    private final File releaseFile;
    private final File outdir;
    private final String options;

    public MakeScriptScript(File releaseFile, File outdir, String options) throws MojoExecutionException {
        this.releaseFile = releaseFile;
        this.outdir = outdir;
        this.options = options != null ? options : "";
    }

    @Override
    public String get() {
        String rel = this.releaseFile.getAbsolutePath().replace(".rel", "");
        String outPath = this.outdir.getAbsolutePath();
        return String.format(this.script, rel, outPath, this.options);
    }

    @Override
    public GenericScriptResult handle(OtpErlangObject result) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)result;
        final String level = ErlUtils.toString(resultTuple.elementAt(0));
        final String messages = ErlUtils.toString(resultTuple.elementAt(1));
        return new GenericScriptResult(){

            @Override
            public boolean success() {
                return "ok".equals(level) || "warn".equals(level);
            }

            @Override
            public void logOutput(Log log) {
                MavenUtils.LogLevel logLevel;
                if (!messages.isEmpty() && (logLevel = MavenUtils.LogLevel.fromString(level)) != MavenUtils.LogLevel.INFO) {
                    MavenUtils.logMultiLineString(log, logLevel, messages);
                }
            }
        };
    }
}

