/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.GenericScriptResult;
import eu.lindenbaum.maven.util.ErlUtils;
import eu.lindenbaum.maven.util.MavenUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public final class MakeRelupScript
extends AbstractScript<GenericScriptResult> {
    private final File relupFile;
    private final File relFile;
    private final List<String> releases;
    private final List<File> paths;

    public MakeRelupScript(File relupFile, File relFile, List<String> releases, List<File> paths) throws MojoExecutionException {
        this.relupFile = relupFile;
        this.relFile = relFile;
        this.releases = releases;
        this.paths = paths;
    }

    @Override
    public String get() {
        String relup = this.relupFile.getAbsolutePath();
        String rel = this.relFile.getAbsolutePath().replace(".rel", "");
        String releases = ErlUtils.toList(this.releases, null, "\"", "\"");
        String pathOption = "[{path, " + ErlUtils.toList(this.paths, null, "\"", "\"") + "}]";
        return String.format(this.script, relup, rel, releases, pathOption);
    }

    @Override
    public GenericScriptResult handle(OtpErlangObject result) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)result;
        final String level = ErlUtils.toString(resultTuple.elementAt(0));
        final String messages = ErlUtils.toString(resultTuple.elementAt(1));
        return new GenericScriptResult(){

            @Override
            public boolean success() {
                return "ok".equals(level);
            }

            @Override
            public void logOutput(Log log) {
                if (!messages.isEmpty()) {
                    MavenUtils.logMultiLineString(log, this.success() ? MavenUtils.LogLevel.WARN : MavenUtils.LogLevel.ERROR, messages);
                }
            }
        };
    }
}

