/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.util.ErlUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class GetAttributesScript
extends AbstractScript<String> {
    private final List<File> modules;
    private final String[] attributes;

    public GetAttributesScript(List<File> modules, String ... attributes) throws MojoExecutionException {
        this.modules = modules;
        this.attributes = attributes;
    }

    @Override
    public String get() {
        String modules = ErlUtils.toModuleList(this.modules, "'", "'");
        String attributeList = ErlUtils.toList(this.attributes, null, "'", "'");
        return String.format(this.script, attributeList, modules);
    }

    @Override
    public String handle(OtpErlangObject result) {
        OtpErlangList resultList = (OtpErlangList)result;
        StringBuilder attributes = new StringBuilder("[");
        for (int i = 0; i < resultList.arity(); ++i) {
            if (i != 0) {
                attributes.append(", ");
            }
            attributes.append("'" + ErlUtils.toString(resultList.elementAt(i)) + "'");
        }
        attributes.append("]");
        return attributes.toString();
    }
}

