/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.util.ErlUtils;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public final class DialyzerScript
extends AbstractScript<String[]> {
    private final List<File> directories;
    private final List<File> includes;
    private final String options;

    public DialyzerScript(List<File> directories, List<File> includes, String options) throws MojoExecutionException {
        this.directories = directories;
        this.includes = includes;
        this.options = options;
    }

    @Override
    public String get() {
        String directories = ErlUtils.toFilenameList(this.directories, "\"", "\"");
        String incs = ErlUtils.toFilenameList(this.includes, "\"", "\"");
        String opts = "[" + (this.options != null ? this.options : "") + "]";
        return String.format(this.script, directories, incs, opts);
    }

    @Override
    public String[] handle(OtpErlangObject result) {
        OtpErlangList warnings = (OtpErlangList)result;
        String[] messages = new String[warnings.arity()];
        for (int i = 0; i < warnings.arity(); ++i) {
            messages[i] = ErlUtils.toString(warnings.elementAt(i));
        }
        return messages;
    }
}

