/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.erlang;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.AbstractScript;
import eu.lindenbaum.maven.erlang.CheckAppResult;
import eu.lindenbaum.maven.util.ErlUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public final class CheckAppScript
extends AbstractScript<CheckAppResult> {
    private final File appFile;

    public CheckAppScript(File appFile) throws MojoExecutionException {
        this.appFile = appFile;
    }

    @Override
    public String get() {
        String appFilePath = this.appFile.getAbsolutePath();
        return String.format(this.script, appFilePath);
    }

    @Override
    public CheckAppResult handle(OtpErlangObject result) {
        OtpErlangTuple resultTuple = (OtpErlangTuple)result;
        final OtpErlangObject success = resultTuple.elementAt(0);
        final OtpErlangObject name = resultTuple.elementAt(1);
        final OtpErlangObject version = resultTuple.elementAt(2);
        final OtpErlangObject startModule = resultTuple.elementAt(3);
        final ArrayList<String> modules = new ArrayList<String>();
        OtpErlangList moduleList = (OtpErlangList)resultTuple.elementAt(4);
        for (int i = 0; i < moduleList.arity(); ++i) {
            modules.add(ErlUtils.toString(moduleList.elementAt(i)));
        }
        final ArrayList<String> applications = new ArrayList<String>();
        OtpErlangList applicationList = (OtpErlangList)resultTuple.elementAt(5);
        for (int i = 0; i < applicationList.arity(); ++i) {
            applications.add(ErlUtils.toString(applicationList.elementAt(i)));
        }
        return new CheckAppResult(){

            @Override
            public boolean success() {
                return "ok".equals(ErlUtils.toString(success));
            }

            @Override
            public String getVersion() {
                return ErlUtils.toString(version);
            }

            @Override
            public String getStartModule() {
                return ErlUtils.toString(startModule);
            }

            @Override
            public String getName() {
                return ErlUtils.toString(name);
            }

            @Override
            public List<String> getModules() {
                return modules;
            }

            @Override
            public List<String> getApplications() {
                return applications;
            }

            public String toString() {
                return this.getName() + "::" + this.getVersion();
            }
        };
    }
}

