/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven.archiver;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import eu.lindenbaum.maven.erlang.MavenSelf;
import eu.lindenbaum.maven.erlang.Script;
import eu.lindenbaum.maven.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;

public final class TarGzUnarchiver {
    private final String peer;
    private final String cookie;
    private final File destination;

    public TarGzUnarchiver(String peer, String cookie) {
        this(peer, cookie, new File("."));
    }

    public TarGzUnarchiver(String peer, String cookie, File destination) {
        this.peer = peer;
        this.cookie = cookie;
        this.destination = destination;
    }

    public File getDestination() {
        return this.destination;
    }

    public void extract(File archive) throws IOException {
        block8: {
            if (archive.isFile()) {
                try {
                    FileUtils.ensureDirectories(this.destination);
                }
                catch (MojoExecutionException e) {
                    throw new IOException("failed to create destination directory " + this.destination);
                }
                if (this.destination.exists()) {
                    if (this.destination.isDirectory()) {
                        TarGzUnarchiverScript script = new TarGzUnarchiverScript(archive, this.destination);
                        try {
                            String error = MavenSelf.get(this.cookie).exec(this.peer, script);
                            if (error != null) {
                                throw new IOException("failed to extract archive: " + error);
                            }
                            break block8;
                        }
                        catch (MojoExecutionException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                    throw new IOException(this.destination.toString() + " is not a directory");
                }
                throw new IOException("could not create " + this.destination);
            }
            throw new IOException(archive.toString() + " does not exist");
        }
    }

    private static final class TarGzUnarchiverScript
    implements Script<String> {
        private static final String script = "ok = erl_tar:extract(\"%s\", [compressed, {cwd, \"%s\"}]).";
        private final File archive;
        private final File destination;

        TarGzUnarchiverScript(File archive, File destination) {
            this.archive = archive;
            this.destination = destination;
        }

        @Override
        public String get() {
            String archivePath = this.archive.getAbsolutePath();
            String destinationPath = this.destination.getAbsolutePath();
            return String.format(script, archivePath, destinationPath);
        }

        @Override
        public String handle(OtpErlangObject result) {
            if (!"ok".equals(result.toString())) {
                OtpErlangTuple errorInfo = (OtpErlangTuple)result;
                OtpErlangTuple nameReason = (OtpErlangTuple)errorInfo.elementAt(1);
                return nameReason.elementAt(1).toString();
            }
            return null;
        }
    }
}

