/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven;

import eu.lindenbaum.maven.SourceLayout;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.project.MavenProject;

public class ErlangStdLayout
implements SourceLayout {
    private final MavenProject project;
    private final File base;

    public ErlangStdLayout(MavenProject project) {
        this.project = project;
        this.base = project.getBasedir();
    }

    @Override
    public File base() {
        return this.base;
    }

    @Override
    public File ebin() {
        return new File(this.base, "ebin");
    }

    @Override
    public File appFile() {
        return new File(this.ebin(), this.project.getArtifactId() + ".app");
    }

    @Override
    public File appupFile() {
        return new File(this.ebin(), this.project.getArtifactId() + ".appup");
    }

    @Override
    public File include() {
        return new File(this.base, "include");
    }

    @Override
    public File priv() {
        return new File(this.base, "priv");
    }

    @Override
    public File src() {
        return new File(this.base, "src");
    }

    @Override
    public File mibs() {
        return new File(this.base, "mibs");
    }

    @Override
    public File testInclude() {
        return new File(this.base, "test_include");
    }

    @Override
    public File testPriv() {
        return new File(this.base, "test_priv");
    }

    @Override
    public Collection<File> testSrcs() {
        return Arrays.asList(this.src(), new File(this.base, "test_src"), new File(this.base, "test"));
    }

    @Override
    public File overviewEdoc() {
        return new File(new File(this.base, "doc"), "overview.edoc");
    }

    @Override
    public File relFile() {
        return null;
    }

    @Override
    public File relupFile() {
        return null;
    }

    @Override
    public File sysConfigFile() {
        return null;
    }
}

