/*
 * Decompiled with CFR 0.152.
 */
package eu.lindenbaum.maven;

import eu.lindenbaum.maven.SourceLayout;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.project.MavenProject;

public class ErlangOtpLayout
implements SourceLayout {
    private final MavenProject project;
    private final File base;

    public ErlangOtpLayout(MavenProject project) {
        this.project = project;
        this.base = project.getBasedir();
    }

    @Override
    public File base() {
        return this.base;
    }

    @Override
    public File ebin() {
        return new File(this.base, "src/main/erlang");
    }

    @Override
    public File appFile() {
        return new File(this.ebin(), this.project.getArtifactId() + ".app");
    }

    @Override
    public File appupFile() {
        return new File(this.ebin(), this.project.getArtifactId() + ".appup");
    }

    @Override
    public File include() {
        return new File(this.base, "src/main/include");
    }

    @Override
    public File priv() {
        return new File(this.base, "src/main/priv");
    }

    @Override
    public File src() {
        return new File(this.base, "src/main/erlang");
    }

    @Override
    public File mibs() {
        return new File(this.base, "src/main/mibs");
    }

    @Override
    public File testInclude() {
        return new File(this.base, "src/test/include");
    }

    @Override
    public File testPriv() {
        return new File(this.base, "src/test/priv");
    }

    @Override
    public Collection<File> testSrcs() {
        return Arrays.asList(this.src(), new File(this.base, "src/test/erlang"));
    }

    @Override
    public File overviewEdoc() {
        return new File(new File(new File(this.base, "src"), "site"), "overview.edoc");
    }

    @Override
    public File relFile() {
        return null;
    }

    @Override
    public File relupFile() {
        return null;
    }

    @Override
    public File sysConfigFile() {
        return null;
    }
}

